<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <title>OneChef® India | Premium Food Manufacturing Company</title>

    <meta name="description" content="OneChef® India is a trusted food manufacturing company delivering high-quality food and beverage products. We specialize in hygienic production, premium ingredients, innovative recipes, and consistent product quality.">

    <meta name="keywords" content="OneChef India, food manufacturing company, food manufacturer India, beverage manufacturer, FMCG food production, food processing company, packaged food manufacturer, private label food manufacturing, premium food products, India food company">

    <meta name="author" content="OneChef® India">
    <meta name="robots" content="index, follow">
    <meta name="language" content="English">
    <meta name="revisit-after" content="7 days">
    <meta name="rating" content="General">

    <!-- Open Graph for social sharing -->
    <meta property="og:title" content="OneChef® India | Premium Food Manufacturing Solutions">
    <meta property="og:description" content="Discover high-quality food and beverage products from OneChef® India. Advanced manufacturing, premium ingredients, and consistent taste in every product.">
    <meta property="og:type" content="website">
    <meta property="og:locale" content="en_IN">
    <meta property="og:image" content="assets/images/logo.pngfav.jpg">

    <!-- Twitter Card for social sharing -->
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="OneChef® India | Premium Food Manufacturing Company">
    <meta name="twitter:description" content="High-quality food and beverage manufacturing with strict hygiene, innovation, and consistent product excellence.">
    <meta name="twitter:image" content="assets/images/logo.pngog-image.jpg">

    <!-- Favicon -->
    <link rel="icon" type="image/png" sizes="32x32" href="./assets/images/logo.png">
    <link rel="icon" type="image/png" sizes="16x16" href="./assets/images/logo.png">
    <link rel="apple-touch-icon" href="./assets/images/logo.png">

    <!-- Accessibility improvements -->
    <meta name="theme-color" content="brown">

</head>

<body>
    <?php include 'header.php' ?>

    <style>
        @import url('https://fonts.googleapis.com/css2?family=Poppins:wght@700&display=swap');

        .custom-banner-section {
            width: 100%;
            height: 250px;
            background: url('./assets/images/about-bn.webp') no-repeat center center/cover;
            display: flex;
            align-items: center;
        }

        .custom-banner-box {
            padding: 10px 20px;
            border-radius: 8px;
            text-align: center;
        }

        .custom-banner-box h1 {
            color: #fff;
            font-weight: 500;
            font-size: 3rem;
            margin: 0;
            position: relative;
            left: 80px;
            font-family: "Berkshire Swash", serif;
        }

        @media (max-width: 768px) {
            .custom-banner-section {
                height: 300;
            }

            .custom-banner-box h1 {
                color: #fff;
                font-weight: 500;
                font-size: 2rem;
                margin: 0;
                position: relative;
                left: 60px;
            }
        }

        a {
            text-decoration: none;
        }
    </style>

    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        .cb-main-section {
            width: 100%;
            position: relative;
        }

        .cb-outer {
            background-color: white;
            margin-top: -32px;
            padding: 20px 0;
        }

        .cb-inner {
            max-width: 1200px;
            margin: auto;
            padding: 0 20px;
            display: flex;
            align-items: center;
            gap: 60px;
        }

        .cb-left {
            flex: 1;
        }

        .cb-heading {
            font-size: 2.9rem;
            font-weight: 500;
            color: brown;
            margin-bottom: 20px;
            font-family: "Berkshire Swash", serif;
        }

        .cb-description {
            font-size: 14px;
            line-height: 1.7;
            color: brown;
            margin-bottom: 20px;
            text-align: justify;
        }

        .cb-readmore {
            display: inline-block;
            padding: 12px 28px;
            background-color: transparent;
            color: brown;
            font-size: 14px;
            text-decoration: none;
            border-radius: 4px;
            border: 2px solid brown;
        }

        .cb-readmore:hover {
            color: #f5f5f5;
            background-color: brown;
            transition: 0.4s;
        }

        /* RIGHT SLIDER */
        .cb-right {
            flex: 1;
            position: relative;
            height: 400px;
            width: 100%;
            /* Ensures full width always */
            overflow: hidden;
        }

        .cb-slider {
            width: 100%;
            height: 100%;
            position: relative;
        }

        .cb-slide {
            position: absolute;
            width: 100%;
            height: 100%;
            opacity: 0;
            transform: translateY(20px);
            transition: opacity 1s ease, transform 1s ease;
            animation: floatUpDown 4s ease-in-out infinite;
        }

        .cb-slide.active {
            opacity: 1;
            transform: translateY(0);
            /* We pause the float animation on the active slide so it doesn't conflict with the fade */
            animation-play-state: running;
        }

        .cb-slide img {
            width: 100%;
            height: 100%;
            object-fit: contain;
            border-radius: 10px;
        }



        /* --- MOBILE FIX --- */
        @media (max-width: 768px) {

            .cb-outer {
                margin-top: 0 !important;
                padding-top: 20px;
            }

            .cb-inner {
                flex-direction: column !important;
                gap: 20px;
            }

            /* Force Slider to be visible at top */
            .cb-right {
                order: -1;
                /* Moves slider above text */
                width: 100%;
                /* Full width */
                height: 300px;
                /* FIXED HEIGHT - This solves the visibility issue */
                flex: none;
                /* Prevents flexbox from collapsing it */
                min-height: 250px;
                /* Safety minimum height */
            }

            .cb-left {
                width: 100%;
            }

            .cb-heading {
                font-size: 24px;
                text-align: center;
            }

            .cb-description {
                text-align: center;
            }

            .cb-readmore {
                display: block;
                width: fit-content;
                margin: 15px auto 0;
            }
        }
    </style>

    <section class="custom-banner-section">
        <div class="custom-banner-box">
            <h1>Who We Are</h1>
        </div>
    </section>

    <section class="cb-main-section">
        <div class="cb-outer">
            <div class="cb-inner">

                <div class="cb-left">
                    <h2 class="cb-heading">About OneChef® India</h2>

                    <p class="cb-description">
                        <span class="span">OneChef® India</span> is a trusted food manufacturing company committed to producing high-quality, hygienic, and innovative food products that meet evolving consumer and business demands. We specialize in manufacturing a wide range of food solutions using advanced production technology, premium ingredients, and industry-approved processes to ensure superior taste, nutrition, and consistency.
                    </p>

                    <p class="cb-description">
                        Our modern manufacturing facilities follow strict quality control measures and food safety standards at every stage of production. From sourcing the finest raw materials to processing, packaging, and distribution, we maintain high levels of precision and efficiency to deliver reliable and safe food products to the market.
                    </p>

                    <p class="cb-description">
                        At OneChef® India, we focus on innovation and continuous improvement to develop customized food solutions that meet diverse market requirements. Our experienced team works closely with clients to understand their needs and deliver tailored manufacturing services that support business growth and operational excellence.
                    </p>



                </div>


                <!-- IMAGE SLIDER -->
                <div class="cb-right">
                    <div class="cb-slider">
                        <div class="cb-slide active">
                            <img src="./assets/images/chef.avif" alt="Gift 1">
                        </div>

                    </div>
                </div>

            </div>
        </div>
    </section>


    <script>
        let slides = document.querySelectorAll('.cb-slide');
        let index = 0;

        setInterval(() => {
            slides[index].classList.remove('active');
            index = (index + 1) % slides.length;
            slides[index].classList.add('active');
        }, 3000);
    </script>

    <?php include 'footer.php' ?>
</body>

</html>