<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <title>Limbcare Clinic | Best Prosthetic & Orthotic Center in India | Artificial Limbs & Bionic Solutions</title>

    <meta name="description" content="Limbcare Clinic is a leading Prosthetic and Orthotic Center in India providing advanced artificial limbs, bionic hands, prosthetic legs, orthotics, pediatric orthotics, silicone prosthesis, mobility aids, wheelchairs, and rehabilitation solutions. Located at Beside Brahmkumari Ashram, Anantpur, Phulnakhara, Cuttack Near East College. We deliver customized, high-quality prosthetic and orthotic care with global standards.">

    <meta name="keywords" content="Limbcare Clinic, best prosthetic clinic in India, prosthetic leg India, artificial limb center, bionic hand India, myoelectric prosthesis, prosthetic foot, prosthetic knee joint, prosthetic hip joint, orthotics clinic India, pediatric orthotics, AFO brace, SMO orthosis, CROW walker, diabetic foot care, silicone prosthesis India, cosmetic prosthetic cover, rehabilitation center India, mobility aids India, wheelchair supplier India, CP chair, rollator walker, smart blind stick, hearing aid India, upper limb prosthesis, lower limb prosthesis, sports prosthetics, running blade India, artificial hand India, advanced prosthetics worldwide, limb replacement surgery support, prosthetic socket design, prosthetic suspension system, orthotic supports, calipers India, best artificial limb clinic Cuttack, prosthetic clinic Odisha, limbcare Cuttack, international prosthetic solutions, affordable prosthetics India">

    <meta name="author" content="Limbcare Clinic">
    <meta name="robots" content="index, follow">
    <meta name="language" content="English">
    <meta name="revisit-after" content="7 days">
    <meta name="rating" content="General">

    <!-- Open Graph for social sharing -->
    <meta property="og:title" content="Limbcare Clinic | Advanced Prosthetic & Orthotic Solutions in India">
    <meta property="og:description" content="Get advanced artificial limbs, bionic hands, prosthetic legs, orthotics, pediatric braces, silicone prosthesis, and mobility aids at Limbcare Clinic, Cuttack, India. Trusted prosthetic and rehabilitation center delivering global standard care.">
    <meta property="og:type" content="website">
    <meta property="og:locale" content="en_IN">
    <meta property="og:image" content="assets/images/logos.png">

    <!-- Twitter Card -->
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="Limbcare Clinic | Best Artificial Limb & Orthotic Center in India">
    <meta name="twitter:description" content="Advanced prosthetic legs, bionic hands, orthotic braces, pediatric orthotics, silicone prosthesis and mobility solutions in India. Visit Limbcare Clinic, Cuttack.">
    <meta name="twitter:image" content="assets/images/logos.png">

    <!-- Clinic Address -->
    <meta name="geo.region" content="IN-OD">
    <meta name="geo.placename" content="Cuttack, Odisha, India">
    <meta name="geo.position" content="20.4625;85.8830">
    <meta name="ICBM" content="20.4625, 85.8830">

    <!-- Favicon -->
    <link rel="icon" type="image/png" sizes="32x32" href="./assets/images/logos.png">
    <link rel="icon" type="image/png" sizes="16x16" href="./assets/images/logos.png">
    <link rel="apple-touch-icon" href="./assets/images/logos.png">

    <meta name="theme-color" content="#0e7aa7">
    <link rel="stylesheet" href="./css/style.css">
</head>

<body>
    <!-- ================= WHY CHOOSE US SECTION ================= -->

    <section class="ias-why-section">

        <div class="ias-why-container">

            <!-- Heading -->
            <div class="ias-why-header">
                <h2 class="ias-why-title">Why <span class="span">Choose Limbcare</span></h2>
                <p class="ias-why-subtitle">
                    We deliver excellence through innovation and care
                </p>
            </div>

            <!-- Cards -->
            <div class="ias-why-grid">

                <div class="ias-why-card">
                    <div class="ias-why-icon">
                        <i class="fas fa-user-md"></i>
                    </div>
                    <h3>Expert Team</h3>
                    <p>Highly trained professionals with years of experience.</p>
                </div>

                <div class="ias-why-card">
                    <div class="ias-why-icon">
                        <i class="fas fa-microchip"></i>
                    </div>
                    <h3>Advanced Technology</h3>
                    <p>Modern equipment for precise and effective treatment.</p>
                </div>

                <div class="ias-why-card">
                    <div class="ias-why-icon">
                        <i class="fas fa-heart"></i>
                    </div>
                    <h3>Patient Care</h3>
                    <p>Compassionate and personalized healthcare services.</p>
                </div>

                <div class="ias-why-card">
                    <div class="ias-why-icon">
                        <i class="fas fa-award"></i>
                    </div>
                    <h3>Quality Service</h3>
                    <p>Committed to delivering top-quality solutions.</p>
                </div>

                <div class="ias-why-card">
                    <div class="ias-why-icon">
                        <i class="fas fa-clock"></i>
                    </div>
                    <h3>On-Time Delivery</h3>
                    <p>Efficient service ensuring timely results.</p>
                </div>

                <div class="ias-why-card">
                    <div class="ias-why-icon">
                        <i class="fas fa-handshake"></i>
                    </div>
                    <h3>Trusted Support</h3>
                    <p>Reliable assistance whenever you need it.</p>
                </div>

                <div class="ias-why-card">
                    <div class="ias-why-icon">
                        <i class="fas fa-shield-alt"></i>
                    </div>
                    <h3>Safety Standards</h3>
                    <p>Maintaining the highest safety and hygiene standards.</p>
                </div>

                <div class="ias-why-card">
                    <div class="ias-why-icon">
                        <i class="fas fa-smile"></i>
                    </div>
                    <h3>Customer Satisfaction</h3>
                    <p>Ensuring comfort, confidence, and happiness.</p>
                </div>

            </div>

        </div>

    </section>

    <script>
        document.addEventListener("DOMContentLoaded", function() {
            const elements = document.querySelectorAll(
                ".ias-why-header, .ias-why-card"
            );

            function revealOnScroll() {
                const windowHeight = window.innerHeight;

                elements.forEach((el, index) => {
                    const elementTop = el.getBoundingClientRect().top;

                    if (elementTop < windowHeight - 100) {
                        setTimeout(() => {
                            el.classList.add("show");
                        }, index * 150); // stagger effect
                    }
                });
            }

            window.addEventListener("scroll", revealOnScroll);
            revealOnScroll();
        });
    </script>
</body>

</html>