<?php
include 'admin/connection.php';

// 1. Check if we are viewing a specific Product
$product_data = null;
$category_data = null;
$is_single_product = false;

if (isset($_GET['id']) && !isset($_GET['cat_id'])) {
    // Viewing Single Product Detail
    $pid = (int)$_GET['id'];
    $res = $conn->query("SELECT p.*, pc.name as cat_name, pc.id as cat_id FROM products p JOIN product_categories pc ON p.category_id = pc.id WHERE p.id=$pid AND p.status=1");
    if ($res->num_rows > 0) {
        $product_data = $res->fetch_assoc();
        $category_data = ['id' => $product_data['cat_id'], 'name' => $product_data['cat_name']];
        $is_single_product = true;
    }
} elseif (isset($_GET['cat_id'])) {
    // Viewing Category List (Products inside category)
    $cid = (int)$_GET['cat_id'];
    $res = $conn->query("SELECT * FROM product_categories WHERE id=$cid AND status=1");
    if ($res->num_rows > 0) {
        $category_data = $res->fetch_assoc();
    }
}
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <title>Limbcare Clinic | Best Prosthetic & Orthotic Center in India | Artificial Limbs & Bionic Solutions</title>

    <meta name="description" content="Limbcare Clinic is a leading Prosthetic and Orthotic Center in India providing advanced artificial limbs, bionic hands, prosthetic legs, orthotics, pediatric orthotics, silicone prosthesis, mobility aids, wheelchairs, and rehabilitation solutions. Located at Beside Brahmkumari Ashram, Anantpur, Phulnakhara, Cuttack Near East College. We deliver customized, high-quality prosthetic and orthotic care with global standards.">

    <meta name="keywords" content="Limbcare Clinic, best prosthetic clinic in India, prosthetic leg India, artificial limb center, bionic hand India, myoelectric prosthesis, prosthetic foot, prosthetic knee joint, prosthetic hip joint, orthotics clinic India, pediatric orthotics, AFO brace, SMO orthosis, CROW walker, diabetic foot care, silicone prosthesis India, cosmetic prosthetic cover, rehabilitation center India, mobility aids India, wheelchair supplier India, CP chair, rollator walker, smart blind stick, hearing aid India, upper limb prosthesis, lower limb prosthesis, sports prosthetics, running blade India, artificial hand India, advanced prosthetics worldwide, limb replacement surgery support, prosthetic socket design, prosthetic suspension system, orthotic supports, calipers India, best artificial limb clinic Cuttack, prosthetic clinic Odisha, limbcare Cuttack, international prosthetic solutions, affordable prosthetics India">

    <meta name="author" content="Limbcare Clinic">
    <meta name="robots" content="index, follow">
    <meta name="language" content="English">
    <meta name="revisit-after" content="7 days">
    <meta name="rating" content="General">

    <!-- Open Graph for social sharing -->
    <meta property="og:title" content="Limbcare Clinic | Advanced Prosthetic & Orthotic Solutions in India">
    <meta property="og:description" content="Get advanced artificial limbs, bionic hands, prosthetic legs, orthotics, pediatric braces, silicone prosthesis, and mobility aids at Limbcare Clinic, Cuttack, India. Trusted prosthetic and rehabilitation center delivering global standard care.">
    <meta property="og:type" content="website">
    <meta property="og:locale" content="en_IN">
    <meta property="og:image" content="assets/images/logos.png">

    <!-- Twitter Card -->
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="Limbcare Clinic | Best Artificial Limb & Orthotic Center in India">
    <meta name="twitter:description" content="Advanced prosthetic legs, bionic hands, orthotic braces, pediatric orthotics, silicone prosthesis and mobility solutions in India. Visit Limbcare Clinic, Cuttack.">
    <meta name="twitter:image" content="assets/images/logos.png">

    <!-- Clinic Address -->
    <meta name="geo.region" content="IN-OD">
    <meta name="geo.placename" content="Cuttack, Odisha, India">
    <meta name="geo.position" content="20.4625;85.8830">
    <meta name="ICBM" content="20.4625, 85.8830">

    <!-- Favicon -->
    <link rel="icon" type="image/png" sizes="32x32" href="./assets/images/logos.png">
    <link rel="icon" type="image/png" sizes="16x16" href="./assets/images/logos.png">
    <link rel="apple-touch-icon" href="./assets/images/logos.png">

    <meta name="theme-color" content="#0e7aa7">
    <link rel="stylesheet" href="./css/style.css">
    <style>
        /* Same CSS styles as Blog Detail provided by user */
        .ias-page-banner {
            width: 100%;
            height: 220px;
            background: url("./assets/images/bns.jpg") center center / cover no-repeat;
            position: relative;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .ias-banner-overlay {
            width: 100%;
            height: 100%;
            background: rgba(14, 122, 167, 0.85);
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .ias-banner-overlay h1 {
            color: #fff;
            font-size: 35px;
            font-weight: 600;
            letter-spacing: 1px;
        }

        .ias-breadcrumb-wrapper {
            background: #f2f2f2;
            padding: 12px 40px;
        }

        .ias-breadcrumb {
            font-size: 14px;
        }

        .ias-breadcrumb a {
            color: #0e7aa7;
            text-decoration: none;
        }

        .ias-breadcrumb span {
            color: #333;
        }

        .ias-blog-detail-content p {
            margin-bottom: 15px;
            line-height: 1.7;
        }

        /* Product Grid inside Category Detail */
        .ias-product-list-grid {
            display: grid;
            grid-template-columns: repeat(3, 1fr);
            gap: 20px;
            margin-top: 30px;
        }

        @media (max-width: 768px) {
            .ias-product-list-grid {
                grid-template-columns: 1fr;
            }
        }

        /* Custom Card for Products inside Category */
        .prod-card {
            background: white;
            border: 1px solid #eee;
            border-radius: 8px;
            overflow: hidden;
            text-decoration: none;
            color: #333;
            transition: 0.3s;
        }

        .prod-card:hover {
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.1);
            transform: translateY(-3px);
        }

        .prod-card img {
            width: 100%;
            height: 300px;
            object-fit: contain;
        }

        .prod-card h3 {
            padding: 15px;
            text-align: center;
            font-size: 15px;
            margin: 0;
            background: #0e7aa7;
            color: white;
            font-weight: 500;
        }
    </style>
</head>

<body>
    <?php include 'header.php' ?>

    <section class="ias-page-banner">
        <div class="ias-banner-overlay">
            <h1><?= $is_single_product ? 'Product Detail' : 'Products Category' ?></h1>
        </div>
    </section>

    <div class="ias-breadcrumb-wrapper">
        <div class="ias-breadcrumb">
            <a href="index.php">Home</a> /
            <a href="products.php">Products</a> /
            <?php if ($category_data): ?>
                <a href="product-detail.php?cat_id=<?= $category_data['id'] ?>"><?= htmlspecialchars($category_data['name']) ?></a>
            <?php endif; ?>
            <?php if ($is_single_product): ?>
                / <span><?= htmlspecialchars($product_data['title']) ?></span>
            <?php endif; ?>
        </div>
    </div>

    <!-- ================= CONTENT SECTION ================= -->
    <section class="ias-blog-detail-section">
        <div class="ias-blog-detail-container">

            <?php if ($is_single_product && $product_data): ?>
                <!-- Single Product View -->
                <div class="ias-blog-detail-row">
                    <div class="ias-blog-detail-left">
                        <h1 class="ias-blog-detail-title span"><?= htmlspecialchars($product_data['title']) ?></h1>
                        <div class="ias-blog-detail-content">
                            <?= $product_data['description'] ?>
                        </div>
                    </div>
                    <div class="ias-blog-detail-right">
                        <?php if (!empty($product_data['image'])): ?>
                            <img src="<?= htmlspecialchars($product_data['image']) ?>" alt="">
                        <?php endif; ?>
                    </div>
                </div>

            <?php elseif ($category_data): ?>
                <!-- Category List View -->
                <div style="text-align:center;">
                    <h1 class="ias-blog-detail-title span"><?= htmlspecialchars($category_data['name']) ?></h1>
                    <div class="ias-blog-detail-content">
                        <?= $category_data['description'] ?>
                    </div>
                </div>

                <h2 class="ias-related-title">Products Of <span class="span"><?= htmlspecialchars($category_data['name']) ?></span></h2>
                <div class="ias-product-list-grid">
                    <?php
                    $cat_id = $category_data['id'];
                    $prods = $conn->query("SELECT * FROM products WHERE category_id=$cat_id AND status=1");
                    if ($prods->num_rows > 0) {
                        while ($p = $prods->fetch_assoc()) {
                    ?>
                            <a href="product-detail.php?id=<?= $p['id'] ?>" class="prod-card">
                                <img src="<?= $p['image'] ?>" alt="">
                                <h3><?= htmlspecialchars($p['title']) ?></h3>
                            </a>
                    <?php
                        }
                    } else {
                        echo "<p style='grid-column:1/-1; text-align:center;'>No products found in this category.</p>";
                    }
                    ?>
                </div>

            <?php else: ?>
                <p style="text-align:center; padding:50px;">Content not found.</p>
            <?php endif; ?>
        </div>
    </section>

    <!-- ================= RELATED ITEMS ================= -->
    <section class="ias-related-blog-section">
        <div class="ias-related-container">
            <h2 class="ias-related-title span"><?= $is_single_product ? 'Other Products' : 'Other Categories' ?></h2>
            <div class="ias-related-grid">
                <?php
                if ($is_single_product && $category_data) {
                    // Show other products from same category
                    $current_id = $product_data['id'];
                    $cat_id = $category_data['id'];
                    $related = $conn->query("SELECT * FROM products WHERE category_id=$cat_id AND id != $current_id AND status=1 LIMIT 3");
                    while ($r = $related->fetch_assoc()) {
                ?>
                        <div class="ias-related-card">
                            <div class="ias-related-image">
                                <img src="<?= $r['image'] ?>" alt="">
                            </div>
                            <div class="ias-related-content">
                                <h3 class="span"><?= htmlspecialchars($r['title']) ?></h3>
                                <a href="product-detail.php?id=<?= $r['id'] ?>" class="ias-related-btn">View Details</a>
                            </div>
                        </div>
                        <?php
                    }
                } else {
                    // Show other categories
                    if ($category_data) {
                        $current_cat = $category_data['id'];
                        $related = $conn->query("SELECT * FROM product_categories WHERE id != $current_cat AND status=1 LIMIT 3");
                        while ($r = $related->fetch_assoc()) {
                        ?>
                            <div class="ias-related-card">
                                <div class="ias-related-image">
                                    <img src="<?= $r['image'] ?>" alt="">
                                </div>
                                <div class="ias-related-content">
                                    <h3 class="span"><?= htmlspecialchars($r['name']) ?></h3>
                                    <a href="product-detail.php?cat_id=<?= $r['id'] ?>" class="ias-related-btn">View Products</a>
                                </div>
                            </div>
                <?php
                        }
                    }
                }
                ?>
            </div>
        </div>
    </section>

    <?php include 'footer.php' ?>
</body>

</html>