<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <title>Limbcare Clinic | Best Prosthetic & Orthotic Center in India | Artificial Limbs & Bionic Solutions</title>

    <meta name="description" content="Limbcare Clinic is a leading Prosthetic and Orthotic Center in India providing advanced artificial limbs, bionic hands, prosthetic legs, orthotics, pediatric orthotics, silicone prosthesis, mobility aids, wheelchairs, and rehabilitation solutions. Located at Beside Brahmkumari Ashram, Anantpur, Phulnakhara, Cuttack Near East College. We deliver customized, high-quality prosthetic and orthotic care with global standards.">

    <meta name="keywords" content="Limbcare Clinic, best prosthetic clinic in India, prosthetic leg India, artificial limb center, bionic hand India, myoelectric prosthesis, prosthetic foot, prosthetic knee joint, prosthetic hip joint, orthotics clinic India, pediatric orthotics, AFO brace, SMO orthosis, CROW walker, diabetic foot care, silicone prosthesis India, cosmetic prosthetic cover, rehabilitation center India, mobility aids India, wheelchair supplier India, CP chair, rollator walker, smart blind stick, hearing aid India, upper limb prosthesis, lower limb prosthesis, sports prosthetics, running blade India, artificial hand India, advanced prosthetics worldwide, limb replacement surgery support, prosthetic socket design, prosthetic suspension system, orthotic supports, calipers India, best artificial limb clinic Cuttack, prosthetic clinic Odisha, limbcare Cuttack, international prosthetic solutions, affordable prosthetics India">

    <meta name="author" content="Limbcare Clinic">
    <meta name="robots" content="index, follow">
    <meta name="language" content="English">
    <meta name="revisit-after" content="7 days">
    <meta name="rating" content="General">

    <!-- Open Graph for social sharing -->
    <meta property="og:title" content="Limbcare Clinic | Advanced Prosthetic & Orthotic Solutions in India">
    <meta property="og:description" content="Get advanced artificial limbs, bionic hands, prosthetic legs, orthotics, pediatric braces, silicone prosthesis, and mobility aids at Limbcare Clinic, Cuttack, India. Trusted prosthetic and rehabilitation center delivering global standard care.">
    <meta property="og:type" content="website">
    <meta property="og:locale" content="en_IN">
    <meta property="og:image" content="assets/images/logos.png">

    <!-- Twitter Card -->
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="Limbcare Clinic | Best Artificial Limb & Orthotic Center in India">
    <meta name="twitter:description" content="Advanced prosthetic legs, bionic hands, orthotic braces, pediatric orthotics, silicone prosthesis and mobility solutions in India. Visit Limbcare Clinic, Cuttack.">
    <meta name="twitter:image" content="assets/images/logos.png">

    <!-- Clinic Address -->
    <meta name="geo.region" content="IN-OD">
    <meta name="geo.placename" content="Cuttack, Odisha, India">
    <meta name="geo.position" content="20.4625;85.8830">
    <meta name="ICBM" content="20.4625, 85.8830">

    <!-- Favicon -->
    <link rel="icon" type="image/png" sizes="32x32" href="./assets/images/logos.png">
    <link rel="icon" type="image/png" sizes="16x16" href="./assets/images/logos.png">
    <link rel="apple-touch-icon" href="./assets/images/logos.png">

    <meta name="theme-color" content="#0e7aa7">

    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">

    <style>
        /* --- Base Styles --- */
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            background-color: #f4f4f4;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }

        /* --- Social Sidebars --- */
        .social-sidebar {
            position: fixed;
            top: 80%;
            transform: translateY(-50%);
            z-index: 1000;
            display: flex;
            flex-direction: column;
            gap: 15px;
        }

        .social-left {
            left: 20px;
        }

        .social-right {
            right: 20px;
        }

        .social-icon {
            width: 40px;
            height: 40px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-size: 18px;
            position: relative;
            cursor: pointer;
            transition: all 0.3s ease;
            box-shadow: 0 2px 6px rgba(0, 0, 0, 0.2);
            text-decoration: none;
        }

        .social-icon:hover {
            transform: scale(1.1);
        }

        /* --- TOOLTIP STYLES --- */
        .social-icon .tooltip {
            position: absolute;
            background-color: rgba(0, 0, 0, 0.8);
            color: white;
            padding: 5px 10px;
            border-radius: 5px;
            font-size: 12px;
            white-space: nowrap;
            opacity: 0;
            pointer-events: none;
            transition: opacity 0.3s ease, transform 0.3s ease;
            z-index: 10;
            top: 50%;
            transform: translateY(-50%);
        }

        /* Right Sidebar: Tooltip appears on the LEFT */
        .social-right .social-icon .tooltip {
            right: 50px;
        }

        /* Left Sidebar: Tooltip appears on the RIGHT */
        .social-left .social-icon .tooltip {
            left: 50px;
            /* Moves tooltip to the right of the icon */
        }

        .social-icon:hover .tooltip {
            opacity: 1;
        }

        /* Social Colors */
        .facebook {
            background-color: #3b5998;
        }

        .twitter {
            background-color: #1da1f2;
        }

        .instagram {
            background: linear-gradient(45deg, #f09433 0%, #dc2743 50%, #bc1888 100%);
        }

        .youtube {
            background-color: #ff0000;
        }

        .whatsapp {
            background-color: #25d366;
        }

        .linkedin {
            background-color: #0077b5;
        }

        .pinterest {
            background-color: #bd081c;
        }

        /* Chat Button (Green Theme) */
        .chat-launch-btn {
            background-color: #075e54;
            /* WhatsApp Dark Green */
            text-decoration: none;
        }

        /* --- RESPONSIVE CHATBOT STYLES --- */

        .chatbot-popup-container {
            position: fixed;
            /* Desktop Positioning: Aligned with right icons */
            bottom: 100px;
            right: 100px;
            width: 340px;
            height: 450px;
            background: #8bbd4a;
            /* WhatsApp Chat Background */
            border-radius: 10px;
            box-shadow: 0 8px 25px rgba(0, 0, 0, 0.2);
            display: none;
            flex-direction: column;
            overflow: hidden;
            z-index: 999999;
            transform: scale(0);
            opacity: 0;
            transition: transform 0.2s ease-out, opacity 0.2s ease-out;
            transform-origin: bottom right;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }

        .chatbot-popup-container.active {
            display: flex;
            transform: scale(1);
            opacity: 1;
        }

        /* Header (WhatsApp Green) */
        .chatbot-header-area {
            background: #0e7aa7;
            padding: 12px 15px;
            display: flex;
            align-items: center;
            position: relative;
            border-bottom: 1px solid rgba(255, 255, 255, 0.1);
            /* Fixed height for header */
            height: 60px;
            flex-shrink: 0;
        }

        .chatbot-logo-circle {
            width: 40px;
            height: 40px;
            background: white;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            color: #075e54;
            font-weight: bold;
            font-size: 14px;
            margin-right: 10px;
            box-shadow: 0 1px 2px rgba(0, 0, 0, 0.1);
        }

        .chatbot-logo-circle img {
            width: 40px;
            height: 40px;
            border-radius: 50%;
        }

        .chatbot-header-text h3 {
            color: white;
            font-size: 22px;
            font-weight: 500;
            margin-bottom: 2px;
        }

        .chatbot-header-text span {
            color: white;
            font-size: 14px;
            position: relative;
            bottom: 5px;
        }

        /* Close Button Top Right */
        .chatbot-close-btn {
            position: absolute;
            right: 12px;
            top: 50%;
            transform: translateY(-50%);
            background: transparent;
            border: none;
            color: white;
            width: 30px;
            height: 30px;
            border-radius: 50%;
            cursor: pointer;
            font-size: 20px;
            transition: color 0.2s;
        }

        .chatbot-close-btn:hover {
            color: white;
        }

        /* Chat History Area */
        .chatbot-history-box {
            flex: 1;
            padding: 20px 15px;
            overflow-y: auto;
            background-image: url("data:image/svg+xml,%3Csvg width='60' height='60' viewBox='0 0 60 60' xmlns='http://www.w3.org/2000/svg'%3E%3Cg fill='none' fill-rule='evenodd'%3E%3Cg fill='%23d4cfc6' fill-opacity='0.2'%3E%3Cpath d='M36 34v-4h-2v4h-4v2h4v4h2v-4h4v-2h-4zm0-30V0h-2v4h-4v2h4v4h2V6h4V4h-4zM6 34v-4H4v4H0v2h4v4h2v-4h4v-2H6zM6 4V0H4v4H0v2h4v4h2V6h4V4H6z'/%3E%3C/g%3E%3C/g%3E%3C/svg%3E");
            display: flex;
            flex-direction: column;
            gap: 12px;
        }

        .chatbot-msg-row {
            display: flex;
            flex-direction: column;
            max-width: 80%;
            position: relative;
        }

        .chatbot-msg-row.user-msg {
            align-self: flex-end;
        }

        .chatbot-msg-row.bot-msg {
            align-self: flex-start;
        }

        /* WhatsApp Style Bubbles */
        .msg-content-box {
            padding: 8px 12px;
            border-radius: 8px;
            font-size: 13px;
            line-height: 1.5;
            word-wrap: break-word;
            position: relative;
            box-shadow: 0 1px 1px rgba(0, 0, 0, 0.1);
        }

        /* User Message (Green Outgoing) */
        .user-msg .msg-content-box {
            background: #dcf8c6;
            color: #333;
            border-top-right-radius: 0px;
        }

        .user-msg .msg-content-box::after {
            content: '';
            position: absolute;
            top: 0;
            right: -8px;
            width: 0;
            height: 0;
            border-top: 10px solid #dcf8c6;
            border-right: 10px solid transparent;
        }

        /* Bot Message (White Incoming) */
        .bot-msg .msg-content-box {
            background: white;
            color: #333;
            border-top-left-radius: 0px;
        }

        .bot-msg .msg-content-box::after {
            content: '';
            position: absolute;
            top: 0;
            left: -8px;
            width: 0;
            height: 0;
            border-top: 10px solid white;
            border-left: 10px solid transparent;
        }

        /* List Formatting inside bubbles */
        .msg-content-box ul,
        .msg-content-box ol {
            margin: 5px 0;
            padding-left: 20px;
        }

        .msg-content-box li {
            margin-bottom: 4px;
        }

        .msg-content-box strong {
            color: #075e54;
        }

        .msg-timestamp {
            font-size: 12px;
            color: white;
            text-align: right;
            margin-top: 3px;
            padding-right: 5px;
        }

        /* Input Area (Footer) */
        .chatbot-input-area {
            padding: 10px;
            background: #0e7aa7;
            display: flex;
            align-items: center;
            gap: 8px;
            border-top: 1px solid #0e7aa7;
            /* Fixed height for footer */
            height: 60px;
            flex-shrink: 0;
        }

        .chatbot-input-area input {
            flex: 1;
            padding: 10px 15px;
            border: none;
            border-radius: 20px;
            outline: none;
            font-size: 14px;
            background: white;
        }

        .chatbot-input-area button {
            background: #8bbd4a;
            color: white;
            border: none;
            width: 40px;
            height: 40px;
            border-radius: 50%;
            cursor: pointer;
            font-size: 16px;
            transition: transform 0.1s;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .chatbot-input-area button:active {
            transform: scale(0.9);
        }

        /* Typing Indicator */
        .typing-indicator {
            display: flex;
            gap: 4px;
            padding: 10px;
        }

        .typing-indicator span {
            width: 8px;
            height: 8px;
            background: #aaa;
            border-radius: 50%;
            animation: bounce 1s infinite;
        }

        .typing-indicator span:nth-child(2) {
            animation-delay: 0.2s;
        }

        .typing-indicator span:nth-child(3) {
            animation-delay: 0.3s;
        }

        @keyframes bounce {

            0%,
            100% {
                transform: translateY(0);
            }

            50% {
                transform: translateY(-5px);
            }
        }

        /* --- RESPONSIVE MEDIA QUERIES --- */

        /* Tablet & Small Desktop */
        @media (max-width: 768px) {
            .social-sidebar {
                /* Slightly adjust position if needed */
                bottom: 85%;
            }
        }

        /* Mobile Devices */
        @media (max-width: 480px) {

            /* Hide sidebars on mobile to save space, or move them to bottom bar if preferred */
            .social-sidebar {
                display: none;
            }

            /* Make Chatbot Full Width / Full Height Container */
            .chatbot-popup-container {
                width: 100%;
                height: 100vh;
                /* Full screen height */
                bottom: 0;
                right: 0;
                border-radius: 0;
                /* Sharp corners for full screen feel */
                box-shadow: none;
                transform: translateY(100%);
                /* Slide up animation instead of zoom */
                transform-origin: bottom center;
            }

            .chatbot-popup-container.active {
                transform: translateY(0);
            }

            /* Adjust header for mobile notch/status bar */
            .chatbot-header-area {
                padding-top: 15px;
                height: 70px;
            }

            /* Make input bar slightly taller on mobile for easier touch */
            .chatbot-input-area {
                height: 70px;
                padding-bottom: 20px;
                /* Extra padding for bottom gesture bar */
            }

            .chatbot-input-area input {
                font-size: 16px;
                /* Prevents iOS zoom on focus */
            }
        }
    </style>
</head>

<body>

    <!-- Right Social Sidebar -->
    <div class="social-sidebar social-right">
        <!-- Chat Button -->
        <a href="#" class="social-icon chat-launch-btn" id="chatToggleBtn">
            <i class="fas fa-robot"></i>
            <span class="tooltip">Limbcare Chatboat</span>
        </a>

        <a href="tel:+919178295999" class="social-icon pinterest">
            <i class="fa-solid fa-phone"></i>
            <span class="tooltip">Call Us</span>
        </a>
        <a href="https://api.whatsapp.com/send?phone=+91-9178295999&text=Welcome%20To%20Limbcare%20Clinic%20" target="_blank" class="social-icon whatsapp">
            <i class="fab fa-whatsapp"></i>
            <span class="tooltip">WhatsApp</span>
        </a>


    </div>

    <!-- CHATBOT POPUP -->
    <div class="chatbot-popup-container" id="chatPopup">
        <div class="chatbot-header-area">
            <div class="chatbot-logo-circle">
                <img src="./assets/images/logo.png" alt="">
            </div>
            <div class="chatbot-header-text">
                <h3>Limbcare Clinic</h3>
                <span>Online</span>
            </div>
            <button class="chatbot-close-btn" id="chatCloseBtn">
                <i class="fas fa-times"></i>
            </button>
        </div>

        <div class="chatbot-history-box" id="chatHistoryBox">
            <div class="chatbot-msg-row bot-msg">
                <div class="msg-content-box">
                    Hello! Welcome to <b>Limbcare Clinic</b>.<br>
                    How can we assist you with your prosthetic, orthotic, or mobility needs today?
                </div>
                <span class="msg-timestamp">Now</span>
            </div>
        </div>

        <div class="chatbot-input-area">
            <input type="text" id="chatInputField" placeholder="Type a message...">
            <button id="chatSendBtn"><i class="fas fa-paper-plane"></i></button>
        </div>
    </div>

    <script>
        // --- Chatbot Logic ---

        const toggleBtn = document.getElementById('chatToggleBtn');
        const closeBtn = document.getElementById('chatCloseBtn');
        const popup = document.getElementById('chatPopup');
        const inputField = document.getElementById('chatInputField');
        const sendBtn = document.getElementById('chatSendBtn');
        const historyBox = document.getElementById('chatHistoryBox');

        // Toggle Chatbot
        toggleBtn.addEventListener('click', (e) => {
            e.preventDefault();
            popup.classList.toggle('active');
            if (popup.classList.contains('active')) {
                inputField.focus();
            }
        });

        closeBtn.addEventListener('click', () => {
            popup.classList.remove('active');
        });

        // Send Message Function
        function sendMessage() {
            const userMessage = inputField.value.trim();
            if (userMessage === "") return;

            // 1. Add User Message
            addMessageToUI(userMessage, 'user-msg');
            inputField.value = "";

            // 2. Show Typing
            showTypingIndicator();

            // 3. Send to Backend
            const formData = new FormData();
            formData.append('msg', userMessage);

            fetch('reply.php', {
                    method: 'POST',
                    body: formData
                })
                .then(response => response.text())
                .then(data => {
                    removeTypingIndicator();
                    const formattedData = formatBotReply(data);
                    addMessageToUI(formattedData, 'bot-msg');
                })
                .catch(error => {
                    removeTypingIndicator();
                    addMessageToUI("Sorry, I'm having trouble connecting.", 'bot-msg');
                });
        }

        // --- Smart Formatting Function ---
        function formatBotReply(text) {
            // 1. Escape HTML
            let formatted = text
                .replace(/&/g, "&amp;")
                .replace(/</g, "&lt;")
                .replace(/>/g, "&gt;");

            // 2. Format Lists
            formatted = formatted.replace(/(\d+)\.\s+(.*?)\n/g, "<li>$2</li>");
            formatted = formatted.replace(/[\*\-]\s+(.*?)\n/g, "<li>$1</li>");
            formatted = formatted.replace(/(<li>.*?<\/li>)+/gs, "<ul>$&</ul>");

            // 3. Format Paragraphs
            formatted = formatted.replace(/\n/g, "<br>");

            // 4. Bold keywords
            formatted = formatted.replace(/(interior|exterior|garden|design|landscaping|pan india creation)/gi, "<strong>$1</strong>");

            return formatted;
        }

        // Helper: Add message to chat window
        function addMessageToUI(text, className) {
            const row = document.createElement('div');
            row.classList.add('chatbot-msg-row', className);

            const now = new Date();
            const time = now.getHours() + ":" + String(now.getMinutes()).padStart(2, '0');

            row.innerHTML = `
                <div class="msg-content-box">${text}</div>
                <span class="msg-timestamp">${time}</span>
            `;
            historyBox.appendChild(row);
            historyBox.scrollTop = historyBox.scrollHeight;
        }

        // Helper: Typing Indicator
        function showTypingIndicator() {
            const typingDiv = document.createElement('div');
            typingDiv.classList.add('chatbot-msg-row', 'bot-msg', 'typing-row');
            typingDiv.innerHTML = `
                <div class="msg-content-box typing-indicator">
                    <span></span><span></span><span></span>
                </div>
            `;
            historyBox.appendChild(typingDiv);
            historyBox.scrollTop = historyBox.scrollHeight;
        }

        function removeTypingIndicator() {
            const typing = document.querySelector('.typing-row');
            if (typing) typing.remove();
        }

        // Event Listeners
        sendBtn.addEventListener('click', sendMessage);
        inputField.addEventListener('keypress', (e) => {
            if (e.key === 'Enter') sendMessage();
        });
    </script>
</body>

</html>