<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <title>Limbcare Clinic | Best Prosthetic & Orthotic Center in India | Artificial Limbs & Bionic Solutions</title>

    <meta name="description" content="Limbcare Clinic is a leading Prosthetic and Orthotic Center in India providing advanced artificial limbs, bionic hands, prosthetic legs, orthotics, pediatric orthotics, silicone prosthesis, mobility aids, wheelchairs, and rehabilitation solutions. Located at Beside Brahmkumari Ashram, Anantpur, Phulnakhara, Cuttack Near East College. We deliver customized, high-quality prosthetic and orthotic care with global standards.">

    <meta name="keywords" content="Limbcare Clinic, best prosthetic clinic in India, prosthetic leg India, artificial limb center, bionic hand India, myoelectric prosthesis, prosthetic foot, prosthetic knee joint, prosthetic hip joint, orthotics clinic India, pediatric orthotics, AFO brace, SMO orthosis, CROW walker, diabetic foot care, silicone prosthesis India, cosmetic prosthetic cover, rehabilitation center India, mobility aids India, wheelchair supplier India, CP chair, rollator walker, smart blind stick, hearing aid India, upper limb prosthesis, lower limb prosthesis, sports prosthetics, running blade India, artificial hand India, advanced prosthetics worldwide, limb replacement surgery support, prosthetic socket design, prosthetic suspension system, orthotic supports, calipers India, best artificial limb clinic Cuttack, prosthetic clinic Odisha, limbcare Cuttack, international prosthetic solutions, affordable prosthetics India">

    <meta name="author" content="Limbcare Clinic">
    <meta name="robots" content="index, follow">
    <meta name="language" content="English">
    <meta name="revisit-after" content="7 days">
    <meta name="rating" content="General">

    <!-- Open Graph for social sharing -->
    <meta property="og:title" content="Limbcare Clinic | Advanced Prosthetic & Orthotic Solutions in India">
    <meta property="og:description" content="Get advanced artificial limbs, bionic hands, prosthetic legs, orthotics, pediatric braces, silicone prosthesis, and mobility aids at Limbcare Clinic, Cuttack, India. Trusted prosthetic and rehabilitation center delivering global standard care.">
    <meta property="og:type" content="website">
    <meta property="og:locale" content="en_IN">
    <meta property="og:image" content="assets/images/logos.png">

    <!-- Twitter Card -->
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="Limbcare Clinic | Best Artificial Limb & Orthotic Center in India">
    <meta name="twitter:description" content="Advanced prosthetic legs, bionic hands, orthotic braces, pediatric orthotics, silicone prosthesis and mobility solutions in India. Visit Limbcare Clinic, Cuttack.">
    <meta name="twitter:image" content="assets/images/logos.png">

    <!-- Clinic Address -->
    <meta name="geo.region" content="IN-OD">
    <meta name="geo.placename" content="Cuttack, Odisha, India">
    <meta name="geo.position" content="20.4625;85.8830">
    <meta name="ICBM" content="20.4625, 85.8830">

    <!-- Favicon -->
    <link rel="icon" type="image/png" sizes="32x32" href="./assets/images/logos.png">
    <link rel="icon" type="image/png" sizes="16x16" href="./assets/images/logos.png">
    <link rel="apple-touch-icon" href="./assets/images/logos.png">

    <meta name="theme-color" content="#0e7aa7">
    <link rel="stylesheet" href="./css/style.css">
    <!-- Font Awesome 6 CDN -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css" integrity="sha512-..." crossorigin="anonymous" referrerpolicy="no-referrer" />
</head>

<body>
    <?php
    $current_page = basename($_SERVER['PHP_SELF']);
    ?>

    <div class="ias-header-wrapper" id="iasHeader">

        <!-- TOP BAR -->
        <div class="ias-topbar">
            <div class="ias-social-icons">
                <a href=""><i class="fa-brands fa-youtube"></i></a>
                <a href=""><i class="fa-brands fa-facebook-f"></i></a>
                <a href=""><i class="fa-brands fa-x-twitter"></i></a>
                <a href=""><i class="fa-brands fa-instagram"></i></a>
                <a href=""><i class="fa-brands fa-linkedin-in"></i></a>
                <a href="https://api.whatsapp.com/send?phone=+91-9178295999&text=Welcome%20To%20Limbcare%20Clinic%20" target="_blank"><i class="fa-brands fa-whatsapp"></i></a>
            </div>

            <div class="ias-top-links">
                <a href="tel:9178295999" class="phone">Call On: (+91) 9178295999</a>
                <a href="mailto:madhusmitap875@gmail.com" class="phone">Mail On: madhusmitap875@gmail.com</a>
                <a href="./contact.php" class="ias-appointment-btn">MAKE AN APPOINTMENT</a>
            </div>
        </div>

        <!-- NAVBAR -->
        <div class="ias-navbar">

            <div class="ias-logo">
                <a href="./index.php"><img src="./assets/images/logo.png" alt="Logo"></a>
            </div>

            <div class="ias-nav-menu">
                <ul>
                    <li><a class="<?php if ($current_page == 'index.php') {
                                        echo 'ias-active';
                                    } ?>" href="index.php">Home</a></li>

                    <li>
                        <a class="<?php if ($current_page == 'about.php') {
                                        echo 'ias-active';
                                    } ?>">Who We Are <i class="fa-solid fa-angle-down"></i></a>
                        <div class="ias-dropdown">
                            <a class="<?php if ($current_page == 'about.php') {
                                            echo 'ias-active';
                                        } ?>" href="./about.php"><i class="fa fa-hand-back-fist"></i> About Us</a>
                            <a class="<?php if ($current_page == 'director.php') {
                                            echo 'ias-active';
                                        } ?>" href="./dirtector.php"><i class="fa fa-user-tie"></i> Director Message</a>
                        </div>
                    </li>

                    <li>
                        <a class="<?php if ($current_page == 'product-detail.php') {
                                        echo 'ias-active';
                                    } ?>">Products <i class="fa-solid fa-angle-down"></i></a>
                        <div class="ias-dropdown">
                            <?php
                            include 'admin/connection.php';

                            $res = $conn->query("SELECT * FROM product_categories WHERE status=1 ORDER BY id ASC");
                            if ($res->num_rows > 0) {
                                while ($row = $res->fetch_assoc()) {
                                    echo '<a href="product-detail.php?cat_id=' . $row['id'] . '"><i class="fa-solid fa-wheelchair"></i> ' . htmlspecialchars($row['name']) . '</a>';
                                }
                            } else {
                                echo '<p style="padding:10px;">No categories found</p>';
                            }
                            ?>
                        </div>
                    </li>

                    <li><a class="<?php if ($current_page == 'gallery.php') {
                                        echo 'ias-active';
                                    } ?>" href="./gallery.php">Gallery</a></li>
                    <li><a class="<?php if ($current_page == 'blog.php') {
                                        echo 'ias-active';
                                    } ?>" href="./blog.php">Blog</a></li>
                    <li><a class="<?php if ($current_page == 'faq.php') {
                                        echo 'ias-active';
                                    } ?>" href="./faq.php">FAQ’S</a></li>
                    <li><a class="<?php if ($current_page == 'career.php') {
                                        echo 'ias-active';
                                    } ?>" href="./career.php">Career</a></li>
                    <li><a class="<?php if ($current_page == 'contact.php') {
                                        echo 'ias-active';
                                    } ?>" href="./contact.php">Contact us</a></li>
                </ul>
            </div>

            <div class="ias-search-box">
                <input type="text" id="productSearch" placeholder="Search Here!">
                <i class="fa fa-search"></i>
                <div id="searchResults" class="search-results"></div>
            </div>

            <div class="ias-hamburger" onclick="iasOpenMenu()">
                <i class="fa fa-bars"></i>
            </div>

        </div>

    </div>


    <!-- MOBILE MENU -->
    <div class="ias-mobile-menu" id="iasMobileMenu">

        <ul>
            <li><a href="index.php">Home</a></li>

            <li>
                <div class="ias-mobile-toggle" onclick="iasToggleDropdown(this)">Who We Are <i class="fa-solid fa-angle-down"></i></div>
                <div class="ias-mobile-dropdown">
                    <a href="./about.php">About Us</a>
                    <a href="./dirtector.php">Director Message</a>
                </div>
            </li>

            <li>
                <div class="ias-mobile-toggle" onclick="iasToggleDropdown(this)">Products <i class="fa-solid fa-angle-down"></i></div>
                <div class="ias-mobile-dropdown">
                    <?php
                    include 'admin/connection.php';

                    $res = $conn->query("SELECT * FROM product_categories WHERE status=1 ORDER BY id ASC");
                    if ($res->num_rows > 0) {
                        while ($row = $res->fetch_assoc()) {
                            echo '<a href="product-detail.php?cat_id=' . $row['id'] . '">' . htmlspecialchars($row['name']) . '</a>';
                        }
                    } else {
                        echo '<p style="padding:10px;">No categories found</p>';
                    }
                    ?>
                </div>
            </li>

            <li><a href="./gallery.php">Gallery</a></li>
            <li><a href="./blog.php">Blog</a></li>
            <li><a href="./faq.php">FAQ’S</a></li>
            <li><a href="./career.php">Career</a></li>
            <li><a href="./contact.php">Contact us</a></li>
        </ul>

    </div>

    <script src="./js/script.js"></script>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const searchInput = document.getElementById('productSearch');
            const resultsBox = document.getElementById('searchResults');

            searchInput.addEventListener('input', function() {
                const query = this.value.trim();
                if (query.length > 1) {
                    fetch('search.php?q=' + encodeURIComponent(query))
                        .then(response => response.text())
                        .then(data => {
                            resultsBox.innerHTML = data;
                            resultsBox.style.display = 'block';
                        });
                } else {
                    resultsBox.style.display = 'none';
                }
            });

            // Hide dropdown if clicked outside
            document.addEventListener('click', function(e) {
                if (!searchInput.contains(e.target) && !resultsBox.contains(e.target)) {
                    resultsBox.style.display = 'none';
                }
            });
        });
    </script>

    <script>
        window.addEventListener("scroll", function() {
            var header = document.getElementById("iasHeader");

            if (window.scrollY > 100) {
                header.classList.add("ias-sticky");
            } else {
                header.classList.remove("ias-sticky");
            }
        });
    </script>
</body>

</html>