<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <title>Limbcare Clinic | Best Prosthetic & Orthotic Center in India | Artificial Limbs & Bionic Solutions</title>

    <meta name="description" content="Limbcare Clinic is a leading Prosthetic and Orthotic Center in India providing advanced artificial limbs, bionic hands, prosthetic legs, orthotics, pediatric orthotics, silicone prosthesis, mobility aids, wheelchairs, and rehabilitation solutions. Located at Beside Brahmkumari Ashram, Anantpur, Phulnakhara, Cuttack Near East College. We deliver customized, high-quality prosthetic and orthotic care with global standards.">

    <meta name="keywords" content="Limbcare Clinic, best prosthetic clinic in India, prosthetic leg India, artificial limb center, bionic hand India, myoelectric prosthesis, prosthetic foot, prosthetic knee joint, prosthetic hip joint, orthotics clinic India, pediatric orthotics, AFO brace, SMO orthosis, CROW walker, diabetic foot care, silicone prosthesis India, cosmetic prosthetic cover, rehabilitation center India, mobility aids India, wheelchair supplier India, CP chair, rollator walker, smart blind stick, hearing aid India, upper limb prosthesis, lower limb prosthesis, sports prosthetics, running blade India, artificial hand India, advanced prosthetics worldwide, limb replacement surgery support, prosthetic socket design, prosthetic suspension system, orthotic supports, calipers India, best artificial limb clinic Cuttack, prosthetic clinic Odisha, limbcare Cuttack, international prosthetic solutions, affordable prosthetics India">

    <meta name="author" content="Limbcare Clinic">
    <meta name="robots" content="index, follow">
    <meta name="language" content="English">
    <meta name="revisit-after" content="7 days">
    <meta name="rating" content="General">

    <!-- Open Graph for social sharing -->
    <meta property="og:title" content="Limbcare Clinic | Advanced Prosthetic & Orthotic Solutions in India">
    <meta property="og:description" content="Get advanced artificial limbs, bionic hands, prosthetic legs, orthotics, pediatric braces, silicone prosthesis, and mobility aids at Limbcare Clinic, Cuttack, India. Trusted prosthetic and rehabilitation center delivering global standard care.">
    <meta property="og:type" content="website">
    <meta property="og:locale" content="en_IN">
    <meta property="og:image" content="assets/images/logos.png">

    <!-- Twitter Card -->
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="Limbcare Clinic | Best Artificial Limb & Orthotic Center in India">
    <meta name="twitter:description" content="Advanced prosthetic legs, bionic hands, orthotic braces, pediatric orthotics, silicone prosthesis and mobility solutions in India. Visit Limbcare Clinic, Cuttack.">
    <meta name="twitter:image" content="assets/images/logos.png">

    <!-- Clinic Address -->
    <meta name="geo.region" content="IN-OD">
    <meta name="geo.placename" content="Cuttack, Odisha, India">
    <meta name="geo.position" content="20.4625;85.8830">
    <meta name="ICBM" content="20.4625, 85.8830">

    <!-- Favicon -->
    <link rel="icon" type="image/png" sizes="32x32" href="./assets/images/logos.png">
    <link rel="icon" type="image/png" sizes="16x16" href="./assets/images/logos.png">
    <link rel="apple-touch-icon" href="./assets/images/logos.png">

    <meta name="theme-color" content="#0e7aa7">
    <link rel="stylesheet" href="./css/style.css">
    <!-- Added Database Connection -->
    <?php include 'admin/connection.php'; ?>
    <style>
        /* ================= PAGE BANNER ================= */

        .ias-page-banner {
            width: 100%;
            height: 220px;
            background: url("./assets/images/bns.jpg") center center / cover no-repeat;
            position: relative;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .ias-banner-overlay {
            width: 100%;
            height: 100%;
            background: rgba(14, 122, 167, 0.85);
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .ias-banner-overlay h1 {
            color: #fff;
            font-size: 40px;
            font-weight: 600;
            letter-spacing: 1px;
        }

        /* ================= BREADCRUMB ================= */

        .ias-breadcrumb-wrapper {
            background: #f2f2f2;
            padding: 12px 40px;
        }

        .ias-breadcrumb {
            font-size: 14px;
        }

        .ias-breadcrumb a {
            color: #0e7aa7;
            text-decoration: none;
        }

        .ias-breadcrumb span {
            color: #333;
        }

        /* ================= RESPONSIVE ================= */

        @media (max-width: 768px) {

            .ias-page-banner {
                height: 170px;
            }

            .ias-banner-overlay h1 {
                font-size: 28px;
            }

            .ias-breadcrumb-wrapper {
                padding: 10px 20px;
            }

        }
    </style>
</head>

<body>
    <?php include 'header.php' ?>
    <section class="ias-page-banner">

        <div class="ias-banner-overlay">
            <h1>Gallery</h1>
        </div>

    </section>

    <div class="ias-breadcrumb-wrapper">
        <div class="ias-breadcrumb">
            <a href="index.php">Home</a> / <span>Gallery</span>
        </div>
    </div>

    <!-- ================= GALLERY SECTION (DYNAMIC) ================= -->

    <section class="ias-gallery-section">

        <div class="ias-gallery-container">

            <h2 class="ias-gallery-title">Our <span class="span">Gallery</span></h2>

            <div class="ias-gallery-grid">
                <?php
                // Fetch only active images
                $gallery_query = $conn->query("SELECT * FROM gallery WHERE status = 1 ORDER BY id DESC");

                if ($gallery_query->num_rows > 0) {
                    while ($img = $gallery_query->fetch_assoc()) {
                ?>
                        <div class="ias-gallery-item">
                            <!-- Output dynamic image path -->
                            <img src="<?= htmlspecialchars($img['image']) ?>" alt="Gallery Image">
                        </div>
                <?php
                    }
                } else {
                    echo "<p style='text-align:center; width:100%;'>Gallery is empty.</p>";
                }
                ?>
            </div>

        </div>

    </section>

    <!-- ================= LIGHTBOX SLIDER ================= -->

    <div class="ias-gallery-lightbox" id="iasGalleryLightbox">

        <span class="ias-gallery-close">&times;</span>

        <img class="ias-gallery-lightbox-img" id="iasGalleryLightboxImg">

        <button class="ias-gallery-prev">&#10094;</button>
        <button class="ias-gallery-next">&#10095;</button>

    </div>
    <?php include 'footer.php' ?>

    <script>
        // Standard script to select all images inside .ias-gallery-item
        const iasGalleryImages = document.querySelectorAll(".ias-gallery-item img");
        const iasLightbox = document.getElementById("iasGalleryLightbox");
        const iasLightboxImg = document.getElementById("iasGalleryLightboxImg");

        const iasPrevBtn = document.querySelector(".ias-gallery-prev");
        const iasNextBtn = document.querySelector(".ias-gallery-next");
        const iasCloseBtn = document.querySelector(".ias-gallery-close");

        let iasCurrentIndex = 0;

        function iasShowImage(index) {
            iasLightbox.style.display = "flex";
            iasLightboxImg.src = iasGalleryImages[index].src;
            iasCurrentIndex = index;
        }

        iasGalleryImages.forEach((img, index) => {
            img.addEventListener("click", () => {
                iasShowImage(index);
            });
        });

        iasNextBtn.addEventListener("click", () => {
            iasCurrentIndex = (iasCurrentIndex + 1) % iasGalleryImages.length;
            iasShowImage(iasCurrentIndex);
        });

        iasPrevBtn.addEventListener("click", () => {
            iasCurrentIndex =
                (iasCurrentIndex - 1 + iasGalleryImages.length) %
                iasGalleryImages.length;
            iasShowImage(iasCurrentIndex);
        });

        iasCloseBtn.addEventListener("click", () => {
            iasLightbox.style.display = "none";
        });

        iasLightbox.addEventListener("click", (e) => {
            if (e.target === iasLightbox) {
                iasLightbox.style.display = "none";
            }
        });
    </script>

</body>

</html>