<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <title>Limbcare Clinic | Best Prosthetic & Orthotic Center in India | Artificial Limbs & Bionic Solutions</title>

    <meta name="description" content="Limbcare Clinic is a leading Prosthetic and Orthotic Center in India providing advanced artificial limbs, bionic hands, prosthetic legs, orthotics, pediatric orthotics, silicone prosthesis, mobility aids, wheelchairs, and rehabilitation solutions. Located at Beside Brahmkumari Ashram, Anantpur, Phulnakhara, Cuttack Near East College. We deliver customized, high-quality prosthetic and orthotic care with global standards.">

    <meta name="keywords" content="Limbcare Clinic, best prosthetic clinic in India, prosthetic leg India, artificial limb center, bionic hand India, myoelectric prosthesis, prosthetic foot, prosthetic knee joint, prosthetic hip joint, orthotics clinic India, pediatric orthotics, AFO brace, SMO orthosis, CROW walker, diabetic foot care, silicone prosthesis India, cosmetic prosthetic cover, rehabilitation center India, mobility aids India, wheelchair supplier India, CP chair, rollator walker, smart blind stick, hearing aid India, upper limb prosthesis, lower limb prosthesis, sports prosthetics, running blade India, artificial hand India, advanced prosthetics worldwide, limb replacement surgery support, prosthetic socket design, prosthetic suspension system, orthotic supports, calipers India, best artificial limb clinic Cuttack, prosthetic clinic Odisha, limbcare Cuttack, international prosthetic solutions, affordable prosthetics India">

    <meta name="author" content="Limbcare Clinic">
    <meta name="robots" content="index, follow">
    <meta name="language" content="English">
    <meta name="revisit-after" content="7 days">
    <meta name="rating" content="General">

    <!-- Open Graph for social sharing -->
    <meta property="og:title" content="Limbcare Clinic | Advanced Prosthetic & Orthotic Solutions in India">
    <meta property="og:description" content="Get advanced artificial limbs, bionic hands, prosthetic legs, orthotics, pediatric braces, silicone prosthesis, and mobility aids at Limbcare Clinic, Cuttack, India. Trusted prosthetic and rehabilitation center delivering global standard care.">
    <meta property="og:type" content="website">
    <meta property="og:locale" content="en_IN">
    <meta property="og:image" content="assets/images/logos.png">

    <!-- Twitter Card -->
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="Limbcare Clinic | Best Artificial Limb & Orthotic Center in India">
    <meta name="twitter:description" content="Advanced prosthetic legs, bionic hands, orthotic braces, pediatric orthotics, silicone prosthesis and mobility solutions in India. Visit Limbcare Clinic, Cuttack.">
    <meta name="twitter:image" content="assets/images/logos.png">

    <!-- Clinic Address -->
    <meta name="geo.region" content="IN-OD">
    <meta name="geo.placename" content="Cuttack, Odisha, India">
    <meta name="geo.position" content="20.4625;85.8830">
    <meta name="ICBM" content="20.4625, 85.8830">

    <!-- Favicon -->
    <link rel="icon" type="image/png" sizes="32x32" href="./assets/images/logos.png">
    <link rel="icon" type="image/png" sizes="16x16" href="./assets/images/logos.png">
    <link rel="apple-touch-icon" href="./assets/images/logos.png">

    <meta name="theme-color" content="#0e7aa7">
    <link rel="stylesheet" href="./css/style.css">
    <?php
    include 'admin/connection.php';
    include 'icons.php';
    ?>
</head>

<body>
    <!-- ================= FOOTER START ================= -->

    <div class="ias-footer-wrapper">

        <div class="ias-footer-main">

            <!-- Column 1 -->
            <div class="ias-footer-col">
                <a href="./index.php"><img src="./assets/images/logos.png" class="ias-footer-logo" alt="Logo"></a>
                <p class="ias-footer-about">
                    Limbcare Clinic is a trusted prosthetic and orthotic center in India, committed to restoring mobility and confidence to individuals with limb loss and physical challenges. The clinic provides advanced artificial body parts designed for comfort, durability, and precision.
                </p>

                <div class="ias-footer-social">
                    <a href=""><i class="fa-brands fa-youtube icons"></i></a>
                    <a href=""><i class="fa-brands fa-facebook-f icons"></i></a>
                    <a href=""><i class="fa-brands fa-x-twitter icons"></i></a>
                    <a href=""><i class="fa-brands fa-instagram icons"></i></a>
                    <a href=""><i class="fa-brands fa-linkedin-in icons"></i></a>
                    <a href="https://api.whatsapp.com/send?phone=+91-9178295999&text=Welcome%20To%20Limbcare%20Clinic%20" target="_blank"><i class="fa-brands fa-whatsapp icons"></i></a>
                </div>
            </div>

            <!-- Column 2 -->
            <div class="ias-footer-col">
                <h3>Quick Links</h3>
                <ul>
                    <li><a href="index.php"><i class="fa-solid fa-arrow-right"></i> Home</a></li>
                    <li><a href="about.php"><i class="fa-solid fa-arrow-right"></i> About Us</a></li>
                    <li><a href="./product.php"><i class="fa-solid fa-arrow-right"></i> Products</a></li>
                    <li><a href="./gallery.php"><i class="fa-solid fa-arrow-right"></i> Gallery</a></li>
                    <li><a href="./blog.php"><i class="fa-solid fa-arrow-right"></i> Blog</a></li>
                    <li><a href="./faq.php"><i class="fa-solid fa-arrow-right"></i> FAQ'S</a></li>
                    <li><a href="./career.php"><i class="fa-solid fa-arrow-right"></i> Career</a></li>
                    <li><a href="./contact.php"><i class="fa-solid fa-arrow-right"></i> Contact Us</a></li>
                </ul>
            </div>

            <!-- Column 3 -->
            <div class="ias-footer-col">
                <h3>Our Products</h3>
                <ul>
                    <?php

                    $res = $conn->query("SELECT * FROM product_categories WHERE status=1 ORDER BY id ASC LIMIT 8");
                    if ($res->num_rows > 0) {
                        while ($row = $res->fetch_assoc()) {
                            echo '<li><a href="product-detail.php?cat_id=' . $row['id'] . '"><i class="fa-solid fa-arrow-right"></i> ' . htmlspecialchars($row['name']) . '</a></li>';
                        }
                    } else {
                        echo '<li>No products found.</li>';
                    }
                    ?>
                </ul>
            </div>

            <!-- Column 4 -->
            <div class="ias-footer-col">
                <h3>Contact Us</h3>
                <ul>
                    <li><a href="https://maps.app.goo.gl/R8iuMyy4Z1K8RMSX7" target="_blank"><i class="fa-solid fa-location-dot"></i> Limbcare Clinic Beside Brahmkumari Ashram, Anantpur, Phulnakhara, Cuttack Near East College</a></li>
                    <li><a href="tel:+91-9178295999"><i class="fa-solid fa-phone"></i> (+91) 9178295999</a></li>
                    <li><a href="tel:+91-7070981777"><i class="fa-solid fa-phone"></i> (+91) 7070981777</a></li>
                    <li><a href="mailto:madhusmitap875@gmail.com"><i class="fa-solid fa-envelope"></i> madhusmitap875@gmail.com</a></li>
                    <li><a href="https://www.freecounterstat.com" title="website hit counter"><img src="https://counter1.optistats.ovh/private/freecounterstat.php?c=abab5a917dtb2jyw4pg4ef8kjfrb1srb" border="0" title="website hit counter" alt="website hit counter"></a></li>
                </ul>
            </div>

        </div>

        <div class="ias-footer-bottom">
            © 2026 Limbcare Clinic. All Rights Reserved. | Designed & Develped By : <a href="https://erainfotech.in" target="_blank" style="color: whitesmoke;">Erainfotech</a>
        </div>

    </div>

    <!-- ================= FOOTER END ================= -->
</body>

</html>