<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <title>Limbcare Clinic | Best Prosthetic & Orthotic Center in India | Artificial Limbs & Bionic Solutions</title>

    <meta name="description" content="Limbcare Clinic is a leading Prosthetic and Orthotic Center in India providing advanced artificial limbs, bionic hands, prosthetic legs, orthotics, pediatric orthotics, silicone prosthesis, mobility aids, wheelchairs, and rehabilitation solutions. Located at Beside Brahmkumari Ashram, Anantpur, Phulnakhara, Cuttack Near East College. We deliver customized, high-quality prosthetic and orthotic care with global standards.">

    <meta name="keywords" content="Limbcare Clinic, best prosthetic clinic in India, prosthetic leg India, artificial limb center, bionic hand India, myoelectric prosthesis, prosthetic foot, prosthetic knee joint, prosthetic hip joint, orthotics clinic India, pediatric orthotics, AFO brace, SMO orthosis, CROW walker, diabetic foot care, silicone prosthesis India, cosmetic prosthetic cover, rehabilitation center India, mobility aids India, wheelchair supplier India, CP chair, rollator walker, smart blind stick, hearing aid India, upper limb prosthesis, lower limb prosthesis, sports prosthetics, running blade India, artificial hand India, advanced prosthetics worldwide, limb replacement surgery support, prosthetic socket design, prosthetic suspension system, orthotic supports, calipers India, best artificial limb clinic Cuttack, prosthetic clinic Odisha, limbcare Cuttack, international prosthetic solutions, affordable prosthetics India">

    <meta name="author" content="Limbcare Clinic">
    <meta name="robots" content="index, follow">
    <meta name="language" content="English">
    <meta name="revisit-after" content="7 days">
    <meta name="rating" content="General">

    <!-- Open Graph for social sharing -->
    <meta property="og:title" content="Limbcare Clinic | Advanced Prosthetic & Orthotic Solutions in India">
    <meta property="og:description" content="Get advanced artificial limbs, bionic hands, prosthetic legs, orthotics, pediatric braces, silicone prosthesis, and mobility aids at Limbcare Clinic, Cuttack, India. Trusted prosthetic and rehabilitation center delivering global standard care.">
    <meta property="og:type" content="website">
    <meta property="og:locale" content="en_IN">
    <meta property="og:image" content="assets/images/logos.png">

    <!-- Twitter Card -->
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="Limbcare Clinic | Best Artificial Limb & Orthotic Center in India">
    <meta name="twitter:description" content="Advanced prosthetic legs, bionic hands, orthotic braces, pediatric orthotics, silicone prosthesis and mobility solutions in India. Visit Limbcare Clinic, Cuttack.">
    <meta name="twitter:image" content="assets/images/logos.png">

    <!-- Clinic Address -->
    <meta name="geo.region" content="IN-OD">
    <meta name="geo.placename" content="Cuttack, Odisha, India">
    <meta name="geo.position" content="20.4625;85.8830">
    <meta name="ICBM" content="20.4625, 85.8830">

    <!-- Favicon -->
    <link rel="icon" type="image/png" sizes="32x32" href="./assets/images/logos.png">
    <link rel="icon" type="image/png" sizes="16x16" href="./assets/images/logos.png">
    <link rel="apple-touch-icon" href="./assets/images/logos.png">

    <meta name="theme-color" content="#0e7aa7">
    <link rel="stylesheet" href="./css/style.css">
    <style>
        /* ================= PAGE BANNER ================= */

        .ias-page-banner {
            width: 100%;
            height: 220px;
            background: url("./assets/images/bns.jpg") center center / cover no-repeat;
            position: relative;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .ias-banner-overlay {
            width: 100%;
            height: 100%;
            background: rgba(14, 122, 167, 0.85);
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .ias-banner-overlay h1 {
            color: #fff;
            font-size: 40px;
            font-weight: 600;
            letter-spacing: 1px;
        }

        /* ================= BREADCRUMB ================= */

        .ias-breadcrumb-wrapper {
            background: #f2f2f2;
            padding: 12px 40px;
        }

        .ias-breadcrumb {
            font-size: 14px;
        }

        .ias-breadcrumb a {
            color: #0e7aa7;
            text-decoration: none;
        }

        .ias-breadcrumb span {
            color: #333;
        }

        /* ================= RESPONSIVE ================= */

        @media (max-width: 768px) {

            .ias-page-banner {
                height: 170px;
            }

            .ias-banner-overlay h1 {
                font-size: 28px;
            }

            .ias-breadcrumb-wrapper {
                padding: 10px 20px;
            }

        }
    </style>
</head>

<body>
    <?php include 'header.php' ?>
    <section class="ias-page-banner">

        <div class="ias-banner-overlay">
            <h1>FAQ'S</h1>
        </div>

    </section>

    <div class="ias-breadcrumb-wrapper">
        <div class="ias-breadcrumb">
            <a href="index.php">Home</a> / <span>FAQ'S</span>
        </div>
    </div>

    <!-- ================= FAQ SECTION ================= -->

    <section class="ias-faq-section">

        <div class="ias-faq-container">

            <h2 class="ias-faq-title">Frequently <span class="span">Asked Questions</span></h2>

            <div class="ias-faq-grid">

                <!-- LEFT SIDE (5 FAQs) -->
                <div class="ias-faq-column">

                    <div class="ias-faq-card">
                        <div class="ias-faq-question" onclick="iasToggleFaq(this)">
                            What services do you offer?
                            <i class="fa-solid fa-plus"></i>
                        </div>
                        <div class="ias-faq-answer">
                            We provide advanced prosthetic limbs, orthotic supports, and silicone solutions for functional and cosmetic rehabilitation.
                        </div>
                    </div>

                    <div class="ias-faq-card">
                        <div class="ias-faq-question" onclick="iasToggleFaq(this)">
                            How long does the fitting process take?
                            <i class="fa-solid fa-plus"></i>
                        </div>
                        <div class="ias-faq-answer">
                            Fitting depends on the type of device and individual requirements, typically completed within a few sessions.
                        </div>
                    </div>

                    <div class="ias-faq-card">
                        <div class="ias-faq-question" onclick="iasToggleFaq(this)">
                            Do you provide post-delivery support?
                            <i class="fa-solid fa-plus"></i>
                        </div>
                        <div class="ias-faq-answer">
                            Yes, we offer full aftercare, including adjustments, maintenance guidance, and rehabilitation support.
                        </div>
                    </div>

                    <div class="ias-faq-card">
                        <div class="ias-faq-question" onclick="iasToggleFaq(this)">
                            Is the initial consultation free?
                            <i class="fa-solid fa-plus"></i>
                        </div>
                        <div class="ias-faq-answer">
                            Yes, we provide a free initial consultation to assess your needs and recommend the best solution.
                        </div>
                    </div>

                    <div class="ias-faq-card">
                        <div class="ias-faq-question" onclick="iasToggleFaq(this)">
                            Can products be customized?
                            <i class="fa-solid fa-plus"></i>
                        </div>
                        <div class="ias-faq-answer">
                            Absolutely, each prosthetic or orthotic device is customized for comfort, functionality, and precise fit.
                        </div>
                    </div>

                </div>

                <!-- RIGHT SIDE (5 FAQs) -->
                <div class="ias-faq-column">

                    <div class="ias-faq-card">
                        <div class="ias-faq-question" onclick="iasToggleFaq(this)">
                            What materials are used in your products?
                            <i class="fa-solid fa-plus"></i>
                        </div>
                        <div class="ias-faq-answer">
                            We use lightweight, durable, and medical-grade materials to ensure safety, comfort, and long-lasting performance.
                        </div>
                    </div>

                    <div class="ias-faq-card">
                        <div class="ias-faq-question" onclick="iasToggleFaq(this)">
                            How can I book an appointment?
                            <i class="fa-solid fa-plus"></i>
                        </div>
                        <div class="ias-faq-answer">
                            Appointments can be booked online through our website or by calling our clinic directly.
                        </div>
                    </div>

                    <div class="ias-faq-card">
                        <div class="ias-faq-question" onclick="iasToggleFaq(this)">
                            Do your products come with a warranty?
                            <i class="fa-solid fa-plus"></i>
                        </div>
                        <div class="ias-faq-answer">
                            Yes, all products come with a warranty, which varies depending on the type of device and usage.
                        </div>
                    </div>

                    <div class="ias-faq-card">
                        <div class="ias-faq-question" onclick="iasToggleFaq(this)">
                            Are your specialists certified?
                            <i class="fa-solid fa-plus"></i>
                        </div>
                        <div class="ias-faq-answer">
                            Yes, all our prosthetists, orthotists, and rehabilitation specialists are fully certified and experienced professionals.
                        </div>
                    </div>

                    <div class="ias-faq-card">
                        <div class="ias-faq-question" onclick="iasToggleFaq(this)">
                            Do you provide services outside the city?
                            <i class="fa-solid fa-plus"></i>
                        </div>
                        <div class="ias-faq-answer">
                            Yes, we serve patients from across India and provide guidance for remote consultations when needed.
                        </div>
                    </div>

                </div>

            </div>

        </div>

    </section>

    <?php include 'footer.php' ?>

    <script src="./js/script.js"></script>
</body>

</html>