<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <title>Limbcare Clinic | Best Prosthetic & Orthotic Center in India | Artificial Limbs & Bionic Solutions</title>

    <meta name="description" content="Limbcare Clinic is a leading Prosthetic and Orthotic Center in India providing advanced artificial limbs, bionic hands, prosthetic legs, orthotics, pediatric orthotics, silicone prosthesis, mobility aids, wheelchairs, and rehabilitation solutions. Located at Beside Brahmkumari Ashram, Anantpur, Phulnakhara, Cuttack Near East College. We deliver customized, high-quality prosthetic and orthotic care with global standards.">

    <meta name="keywords" content="Limbcare Clinic, best prosthetic clinic in India, prosthetic leg India, artificial limb center, bionic hand India, myoelectric prosthesis, prosthetic foot, prosthetic knee joint, prosthetic hip joint, orthotics clinic India, pediatric orthotics, AFO brace, SMO orthosis, CROW walker, diabetic foot care, silicone prosthesis India, cosmetic prosthetic cover, rehabilitation center India, mobility aids India, wheelchair supplier India, CP chair, rollator walker, smart blind stick, hearing aid India, upper limb prosthesis, lower limb prosthesis, sports prosthetics, running blade India, artificial hand India, advanced prosthetics worldwide, limb replacement surgery support, prosthetic socket design, prosthetic suspension system, orthotic supports, calipers India, best artificial limb clinic Cuttack, prosthetic clinic Odisha, limbcare Cuttack, international prosthetic solutions, affordable prosthetics India">

    <meta name="author" content="Limbcare Clinic">
    <meta name="robots" content="index, follow">
    <meta name="language" content="English">
    <meta name="revisit-after" content="7 days">
    <meta name="rating" content="General">

    <!-- Open Graph for social sharing -->
    <meta property="og:title" content="Limbcare Clinic | Advanced Prosthetic & Orthotic Solutions in India">
    <meta property="og:description" content="Get advanced artificial limbs, bionic hands, prosthetic legs, orthotics, pediatric braces, silicone prosthesis, and mobility aids at Limbcare Clinic, Cuttack, India. Trusted prosthetic and rehabilitation center delivering global standard care.">
    <meta property="og:type" content="website">
    <meta property="og:locale" content="en_IN">
    <meta property="og:image" content="assets/images/logos.png">

    <!-- Twitter Card -->
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="Limbcare Clinic | Best Artificial Limb & Orthotic Center in India">
    <meta name="twitter:description" content="Advanced prosthetic legs, bionic hands, orthotic braces, pediatric orthotics, silicone prosthesis and mobility solutions in India. Visit Limbcare Clinic, Cuttack.">
    <meta name="twitter:image" content="assets/images/logos.png">

    <!-- Clinic Address -->
    <meta name="geo.region" content="IN-OD">
    <meta name="geo.placename" content="Cuttack, Odisha, India">
    <meta name="geo.position" content="20.4625;85.8830">
    <meta name="ICBM" content="20.4625, 85.8830">

    <!-- Favicon -->
    <link rel="icon" type="image/png" sizes="32x32" href="./assets/images/logos.png">
    <link rel="icon" type="image/png" sizes="16x16" href="./assets/images/logos.png">
    <link rel="apple-touch-icon" href="./assets/images/logos.png">

    <meta name="theme-color" content="#0e7aa7">
    <link rel="stylesheet" href="./css/style.css">
    <style>
        /* ================= PAGE BANNER ================= */

        .ias-page-banner {
            width: 100%;
            height: 220px;
            background: url("./assets/images/bns.jpg") center center / cover no-repeat;
            position: relative;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .ias-banner-overlay {
            width: 100%;
            height: 100%;
            background: rgba(14, 122, 167, 0.85);
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .ias-banner-overlay h1 {
            color: #fff;
            font-size: 40px;
            font-weight: 600;
            letter-spacing: 1px;
        }

        /* ================= BREADCRUMB ================= */

        .ias-breadcrumb-wrapper {
            background: #f2f2f2;
            padding: 12px 40px;
        }

        .ias-breadcrumb {
            font-size: 14px;
        }

        .ias-breadcrumb a {
            color: #0e7aa7;
            text-decoration: none;
        }

        .ias-breadcrumb span {
            color: #333;
        }

        /* ================= RESPONSIVE ================= */

        @media (max-width: 768px) {

            .ias-page-banner {
                height: 170px;
            }

            .ias-banner-overlay h1 {
                font-size: 28px;
            }

            .ias-breadcrumb-wrapper {
                padding: 10px 20px;
            }

        }
    </style>
</head>

<body>
    <?php include 'header.php' ?>
    <section class="ias-page-banner">

        <div class="ias-banner-overlay">
            <h1>Director Message</h1>
        </div>

    </section>

    <div class="ias-breadcrumb-wrapper">
        <div class="ias-breadcrumb">
            <a href="index.php">Home</a> / <span>Director Message</span>
        </div>
    </div>

    <section class="ias-about-section">

        <div class="ias-about-container">

            <div class="ias-about-row">

                <!-- LEFT CONTENT -->
                <div class="ias-about-content">

                    <h2 class="ias-about-title">
                        Message From <span class="span">Our Director</span>
                    </h2>

                    <p class="ias-about-text">
                        At Limbcare Clinic, our commitment is to restore mobility, confidence, and dignity to every patient we serve. We recognize the physical and emotional challenges of limb loss and are dedicated to delivering advanced prosthetic, orthotic, and silicone solutions with compassion and professionalism.
                    </p>

                    <p class="ias-about-text">
                        We believe every individual deserves the opportunity to lead an independent and fulfilling life. Through modern technology, skilled expertise, and personalized care, we provide customized solutions and continuous support throughout the rehabilitation process.
                    </p>

                    <p class="ias-about-text">
                        Excellence, integrity, and patient satisfaction remain at the core of our practice. We strive for continuous improvement to ensure the highest standards of quality and the best possible outcomes for those who trust us with their care.
                    </p>
                    <p class="ias-about-text span" style="font-size: 24px; font-weight:500">
                        <span class="span">Ms. Madhusmita Panda</span><br><span class="span" style="font-size: 15px; position: relative; bottom:15px">[Director Of Limbcare Clinic]</span>
                    </p>

                </div>

                <!-- RIGHT IMAGE -->
                <div class="ias-about-image">
                    <img src="./assets/images/dir.jpg" alt="About Image">
                </div>

            </div>

        </div>

    </section>
    <?php include 'footer.php' ?>
</body>

</html>