<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <title>Limbcare Clinic | Best Prosthetic & Orthotic Center in India | Artificial Limbs & Bionic Solutions</title>

    <meta name="description" content="Limbcare Clinic is a leading Prosthetic and Orthotic Center in India providing advanced artificial limbs, bionic hands, prosthetic legs, orthotics, pediatric orthotics, silicone prosthesis, mobility aids, wheelchairs, and rehabilitation solutions. Located at Beside Brahmkumari Ashram, Anantpur, Phulnakhara, Cuttack Near East College. We deliver customized, high-quality prosthetic and orthotic care with global standards.">

    <meta name="keywords" content="Limbcare Clinic, best prosthetic clinic in India, prosthetic leg India, artificial limb center, bionic hand India, myoelectric prosthesis, prosthetic foot, prosthetic knee joint, prosthetic hip joint, orthotics clinic India, pediatric orthotics, AFO brace, SMO orthosis, CROW walker, diabetic foot care, silicone prosthesis India, cosmetic prosthetic cover, rehabilitation center India, mobility aids India, wheelchair supplier India, CP chair, rollator walker, smart blind stick, hearing aid India, upper limb prosthesis, lower limb prosthesis, sports prosthetics, running blade India, artificial hand India, advanced prosthetics worldwide, limb replacement surgery support, prosthetic socket design, prosthetic suspension system, orthotic supports, calipers India, best artificial limb clinic Cuttack, prosthetic clinic Odisha, limbcare Cuttack, international prosthetic solutions, affordable prosthetics India">

    <meta name="author" content="Limbcare Clinic">
    <meta name="robots" content="index, follow">
    <meta name="language" content="English">
    <meta name="revisit-after" content="7 days">
    <meta name="rating" content="General">

    <!-- Open Graph for social sharing -->
    <meta property="og:title" content="Limbcare Clinic | Advanced Prosthetic & Orthotic Solutions in India">
    <meta property="og:description" content="Get advanced artificial limbs, bionic hands, prosthetic legs, orthotics, pediatric braces, silicone prosthesis, and mobility aids at Limbcare Clinic, Cuttack, India. Trusted prosthetic and rehabilitation center delivering global standard care.">
    <meta property="og:type" content="website">
    <meta property="og:locale" content="en_IN">
    <meta property="og:image" content="assets/images/logos.png">

    <!-- Twitter Card -->
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="Limbcare Clinic | Best Artificial Limb & Orthotic Center in India">
    <meta name="twitter:description" content="Advanced prosthetic legs, bionic hands, orthotic braces, pediatric orthotics, silicone prosthesis and mobility solutions in India. Visit Limbcare Clinic, Cuttack.">
    <meta name="twitter:image" content="assets/images/logos.png">

    <!-- Clinic Address -->
    <meta name="geo.region" content="IN-OD">
    <meta name="geo.placename" content="Cuttack, Odisha, India">
    <meta name="geo.position" content="20.4625;85.8830">
    <meta name="ICBM" content="20.4625, 85.8830">

    <!-- Favicon -->
    <link rel="icon" type="image/png" sizes="32x32" href="./assets/images/logos.png">
    <link rel="icon" type="image/png" sizes="16x16" href="./assets/images/logos.png">
    <link rel="apple-touch-icon" href="./assets/images/logos.png">

    <meta name="theme-color" content="#0e7aa7">
    <link rel="stylesheet" href="./css/style.css">
    <style>
        /* ================= PAGE BANNER ================= */

        .ias-page-banner {
            width: 100%;
            height: 220px;
            background: url("./assets/images/bns.jpg") center center / cover no-repeat;
            position: relative;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .ias-banner-overlay {
            width: 100%;
            height: 100%;
            background: rgba(14, 122, 167, 0.85);
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .ias-banner-overlay h1 {
            color: #fff;
            font-size: 40px;
            font-weight: 600;
            letter-spacing: 1px;
        }

        /* ================= BREADCRUMB ================= */

        .ias-breadcrumb-wrapper {
            background: #f2f2f2;
            padding: 12px 40px;
        }

        .ias-breadcrumb {
            font-size: 14px;
        }

        .ias-breadcrumb a {
            color: #0e7aa7;
            text-decoration: none;
        }

        .ias-breadcrumb span {
            color: #333;
        }

        /* ================= RESPONSIVE ================= */

        @media (max-width: 768px) {

            .ias-page-banner {
                height: 170px;
            }

            .ias-banner-overlay h1 {
                font-size: 28px;
            }

            .ias-breadcrumb-wrapper {
                padding: 10px 20px;
            }

        }
    </style>
</head>

<body>
    <?php include 'header.php' ?>
    <!-- ================= PAGE BANNER ================= -->

    <section class="ias-page-banner">

        <div class="ias-banner-overlay">
            <h1>Contact us</h1>
        </div>

    </section>

    <div class="ias-breadcrumb-wrapper">
        <div class="ias-breadcrumb">
            <a href="index.php">Home</a> / <span>Contact us</span>
        </div>
    </div>

    <section class="ias-contact-section">

        <div class="ias-contact-container">

            <!-- LEFT SIDE -->
            <div class="ias-contact-left">

                <h2>Contact <span class="span">us</span></h2>
                <p class="ias-contact-sub">Fill in the form below, and we'll get back to you within 24 hours.</p>

                <h3>Get to <span class="span">Know Us Better</span></h3>
                <p>Contact us, and we will contact you back. Want to chat? We can do that too.</p>

                <div class="ias-contact-info">
                    <p><i class="fa-solid fa-location-dot"></i>
                        <a href="https://maps.app.goo.gl/R8iuMyy4Z1K8RMSX7" target="_blank">Limbcare Clinic Beside Brahmkumari Ashram, Anantpur, Phulnakhara, Cuttack Near East College</a>
                    </p>

                    <p><i class="fa-solid fa-phone"></i> <a href="tel:+91-9178295999">(+91) 9178295999</a></p>
                    <p><i class="fa-solid fa-phone"></i> <a href="tel:+91-7070981777">(+91) 7070981777</a></p>
                    <p><i class="fa-solid fa-envelope"></i> <a href="mailto:madhusmitap875@gmail.com">madhusmitap875@gmail.com</a></p>
                </div>

            </div>


            <!-- RIGHT SIDE FORM -->
            <div class="ias-contact-right">

                <h3>Fill <span class="span">the Form !</span></h3>

                <form class="ias-contact-form"
                    action="send-mail.php"
                    method="POST"
                    onsubmit="return iasValidateCaptcha()">

                    <div class="ias-form-row">
                        <input type="text" name="name" placeholder="Enter your full name" required>
                        <input type="email" name="email" placeholder="Enter your Email ID" required>
                    </div>

                    <div class="ias-form-row">
                        <input type="text" name="phone" placeholder="Enter your Mobile number" required>
                        <input type="text" name="subject" placeholder="Enter your subject" required>
                    </div>

                    <textarea name="message" placeholder="Enter your Message" required class="textarea"></textarea>

                    <div class="ias-captcha-submit-row">

                        <div class="ias-captcha-box">
                            <span id="iasCaptchaCode"></span>
                        </div>

                        <input type="text" id="iasCaptchaInput" placeholder="Enter Captcha" required>

                        <button type="submit" name="submit">SUBMIT</button>

                    </div>

                </form>

            </div>

        </div>
    </section>
    <!-- ================= NEW FULL-WIDTH SECTION ================= -->
    <!-- ================= MAP SECTION ================= -->
    <section class="ias-map-section">
        <iframe
            src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3741.0145303306804!2d85.9126127!3d20.3410184!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x3a190b18ce56eacf%3A0x44fa093262f750d0!2sBrahma%20Kumaris%20Cuttack%20Vishwa%20Shanti%20Sarovar!5e0!3m2!1sen!2sin!4v1771994847943!5m2!1sen!2sin"
            width="100%"
            height="100%"
            style="border:0;"
            allowfullscreen=""
            loading="lazy"
            referrerpolicy="no-referrer-when-downgrade">
        </iframe>
    </section>
    <script src="./js/script.js"></script>
    <?php include 'footer.php' ?>
</body>

</html>