<?php
include 'admin/connection.php';

// Fetch job details
$job_id = isset($_GET['id']) ? (int)$_GET['id'] : 0;
$job = null;

if ($job_id > 0) {
    $res = $conn->query("SELECT * FROM careers WHERE id = $job_id AND status = 1");
    if ($res->num_rows > 0) $job = $res->fetch_assoc();
}

$show_popup = false; // Flag for success popup

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['apply_btn'])) {
    $name = $conn->real_escape_string($_POST['name']);
    $email = $conn->real_escape_string($_POST['email']);
    $phone = $conn->real_escape_string($_POST['phone']);
    $position = $conn->real_escape_string($_POST['position']);
    $message = $conn->real_escape_string($_POST['message']);
    $career_id = (int)$_POST['career_id'];

    $resumePath = "";
    if (!empty($_FILES['resume']['name'])) {
        $targetDir = "assets/resumes/";
        if (!is_dir($targetDir)) mkdir($targetDir, 0777, true);
        $fileName = time() . "_" . basename($_FILES['resume']['name']);
        if (move_uploaded_file($_FILES['resume']['tmp_name'], $targetDir . $fileName)) {
            $resumePath = $targetDir . $fileName;
        }
    }

    if (!empty($resumePath)) {
        $sql = "INSERT INTO career_applications (career_id, name, email, phone, position, resume, message) 
                VALUES ($career_id, '$name', '$email', '$phone', '$position', '$resumePath', '$message')";
        if ($conn->query($sql)) {
            $show_popup = true;
        }
    }
}
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <title>Limbcare Clinic | Best Prosthetic & Orthotic Center in India | Artificial Limbs & Bionic Solutions</title>

    <meta name="description" content="Limbcare Clinic is a leading Prosthetic and Orthotic Center in India providing advanced artificial limbs, bionic hands, prosthetic legs, orthotics, pediatric orthotics, silicone prosthesis, mobility aids, wheelchairs, and rehabilitation solutions. Located at Beside Brahmkumari Ashram, Anantpur, Phulnakhara, Cuttack Near East College. We deliver customized, high-quality prosthetic and orthotic care with global standards.">

    <meta name="keywords" content="Limbcare Clinic, best prosthetic clinic in India, prosthetic leg India, artificial limb center, bionic hand India, myoelectric prosthesis, prosthetic foot, prosthetic knee joint, prosthetic hip joint, orthotics clinic India, pediatric orthotics, AFO brace, SMO orthosis, CROW walker, diabetic foot care, silicone prosthesis India, cosmetic prosthetic cover, rehabilitation center India, mobility aids India, wheelchair supplier India, CP chair, rollator walker, smart blind stick, hearing aid India, upper limb prosthesis, lower limb prosthesis, sports prosthetics, running blade India, artificial hand India, advanced prosthetics worldwide, limb replacement surgery support, prosthetic socket design, prosthetic suspension system, orthotic supports, calipers India, best artificial limb clinic Cuttack, prosthetic clinic Odisha, limbcare Cuttack, international prosthetic solutions, affordable prosthetics India">

    <meta name="author" content="Limbcare Clinic">
    <meta name="robots" content="index, follow">
    <meta name="language" content="English">
    <meta name="revisit-after" content="7 days">
    <meta name="rating" content="General">

    <!-- Open Graph for social sharing -->
    <meta property="og:title" content="Limbcare Clinic | Advanced Prosthetic & Orthotic Solutions in India">
    <meta property="og:description" content="Get advanced artificial limbs, bionic hands, prosthetic legs, orthotics, pediatric braces, silicone prosthesis, and mobility aids at Limbcare Clinic, Cuttack, India. Trusted prosthetic and rehabilitation center delivering global standard care.">
    <meta property="og:type" content="website">
    <meta property="og:locale" content="en_IN">
    <meta property="og:image" content="assets/images/logos.png">

    <!-- Twitter Card -->
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="Limbcare Clinic | Best Artificial Limb & Orthotic Center in India">
    <meta name="twitter:description" content="Advanced prosthetic legs, bionic hands, orthotic braces, pediatric orthotics, silicone prosthesis and mobility solutions in India. Visit Limbcare Clinic, Cuttack.">
    <meta name="twitter:image" content="assets/images/logos.png">

    <!-- Clinic Address -->
    <meta name="geo.region" content="IN-OD">
    <meta name="geo.placename" content="Cuttack, Odisha, India">
    <meta name="geo.position" content="20.4625;85.8830">
    <meta name="ICBM" content="20.4625, 85.8830">

    <!-- Favicon -->
    <link rel="icon" type="image/png" sizes="32x32" href="./assets/images/logos.png">
    <link rel="icon" type="image/png" sizes="16x16" href="./assets/images/logos.png">
    <link rel="apple-touch-icon" href="./assets/images/logos.png">

    <meta name="theme-color" content="#0e7aa7">
    <link rel="stylesheet" href="./css/style.css">
    <!-- SweetAlert2 for beautiful popup -->
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <style>
        /* Existing Styles */
        .ias-page-banner {
            width: 100%;
            height: 220px;
            background: url("./assets/images/bns.jpg") center center / cover no-repeat;
            position: relative;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .ias-banner-overlay {
            width: 100%;
            height: 100%;
            background: rgba(14, 122, 167, 0.85);
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .ias-banner-overlay h1 {
            color: #fff;
            font-size: 40px;
            font-weight: 600;
            letter-spacing: 1px;
        }

        .ias-breadcrumb-wrapper {
            background: #f2f2f2;
            padding: 12px 40px;
        }

        .ias-breadcrumb {
            font-size: 14px;
        }

        .ias-breadcrumb a {
            color: #0e7aa7;
            text-decoration: none;
        }

        .ias-breadcrumb span {
            color: #333;
        }

        @media (max-width: 768px) {
            .ias-page-banner {
                height: 170px;
            }

            .ias-banner-overlay h1 {
                font-size: 28px;
            }

            .ias-breadcrumb-wrapper {
                padding: 10px 20px;
            }
        }

        /* Form Styling */
        .ias-career-form-box input,
        .ias-career-form-box select,
        .ias-career-form-box textarea {
            width: 100%;
            padding: 10px;
            margin-bottom: 10px;
            border: 1px solid #ccc;
            border-radius: 4px;
            box-sizing: border-box;
        }

        .ias-career-row {
            display: flex;
            gap: 10px;
            flex-wrap: wrap;
        }

        .ias-career-col {
            flex: 1;
            min-width: 200px;
        }
    </style>
</head>

<body>
    <?php include 'header.php' ?>
    <section class="ias-page-banner">
        <div class="ias-banner-overlay">
            <h1><?= $job ? htmlspecialchars($job['title']) : 'Not Found' ?></h1>
        </div>
    </section>

    <div class="ias-breadcrumb-wrapper">
        <div class="ias-breadcrumb">
            <a href="index.php">Home</a> / <a href="career.php">Career</a> / <span><?= $job ? htmlspecialchars($job['title']) : 'Not Found' ?></span>
        </div>
    </div>

    <section class="ias-career-detail-section">
        <div class="ias-career-detail-container">
            <?php if ($job): ?>
                <h2 class="ias-career-detail-title">Apply Here To <span class="span">Start Career</span></h2>

                <div class="ias-career-form-box">
                    <form action="" method="post" enctype="multipart/form-data" id="careerForm">
                        <input type="hidden" name="career_id" value="<?= $job['id'] ?>">

                        <div class="ias-career-row">
                            <div class="ias-career-col"><input type="text" name="name" placeholder="Full Name" required></div>
                            <div class="ias-career-col"><input type="email" name="email" placeholder="Email Address" required></div>
                        </div>
                        <div class="ias-career-row">
                            <div class="ias-career-col"><input type="tel" name="phone" placeholder="Phone Number" required></div>
                            <div class="ias-career-col"><input type="file" name="resume" required></div>
                        </div>
                        <div class="ias-career-form-group">
                            <select name="position" required>
                                <option value="">Select Position</option>
                                <option value="<?= htmlspecialchars($job['title']) ?>"><?= htmlspecialchars($job['title']) ?></option>
                            </select>
                        </div>
                        <div class="ias-career-form-group">
                            <textarea name="message" rows="4" placeholder="Cover Letter / Message"></textarea>
                        </div>

                        <!-- CAPTCHA + SUBMIT ROW -->
                        <div class="ias-career-captcha-row">
                            <div class="ias-career-captcha-box">
                                <span id="iasCareerCaptchaText"></span>
                                <button type="button" id="iasCareerRefreshCaptcha">↻</button>
                            </div>
                            <input type="text" id="iasCareerCaptchaInput" placeholder="Enter Captcha" required>
                            <button type="submit" name="apply_btn" class="ias-career-submit-btn">Submit Application</button>
                        </div>
                    </form>
                </div>
            <?php else: ?>
                <p style="text-align:center;">Job not found or expired.</p>
            <?php endif; ?>
        </div>
    </section>
    <?php include 'footer.php' ?>

    <script>
        let iasCareerCaptchaValue = "";

        function iasGenerateCareerCaptcha() {
            const chars = "ABCDEFGHJKLMNPQRSTUVWXYZ23456789";
            let captcha = "";
            for (let i = 0; i < 5; i++) {
                captcha += chars.charAt(Math.floor(Math.random() * chars.length));
            }
            iasCareerCaptchaValue = captcha;
            document.getElementById("iasCareerCaptchaText").innerText = captcha;
        }

        document.getElementById("iasCareerRefreshCaptcha").addEventListener("click", iasGenerateCareerCaptcha);

        document.getElementById("careerForm").addEventListener("submit", function(e) {
            const userInput = document.getElementById("iasCareerCaptchaInput").value;
            if (userInput !== iasCareerCaptchaValue) {
                e.preventDefault();
                alert("Invalid Captcha. Please try again.");
                iasGenerateCareerCaptcha();
            }
        });

        iasGenerateCareerCaptcha();

        <?php if ($show_popup): ?>
            // SweetAlert Popup Script
            Swal.fire({
                icon: 'success',
                title: 'Success!',
                html: '<p style="font-size: 18px;">Application Submitted Successfully.</p><p>Thank you for applying. We will contact you soon.</p>',
                confirmButtonColor: '#0e7aa7',
                confirmButtonText: 'OK'
            }).then((result) => {
                if (result.isConfirmed) {
                    window.location.href = 'career.php';
                }
            });
        <?php endif; ?>
    </script>
</body>

</html>