<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <title>Limbcare Clinic | Best Prosthetic & Orthotic Center in India | Artificial Limbs & Bionic Solutions</title>

    <meta name="description" content="Limbcare Clinic is a leading Prosthetic and Orthotic Center in India providing advanced artificial limbs, bionic hands, prosthetic legs, orthotics, pediatric orthotics, silicone prosthesis, mobility aids, wheelchairs, and rehabilitation solutions. Located at Beside Brahmkumari Ashram, Anantpur, Phulnakhara, Cuttack Near East College. We deliver customized, high-quality prosthetic and orthotic care with global standards.">

    <meta name="keywords" content="Limbcare Clinic, best prosthetic clinic in India, prosthetic leg India, artificial limb center, bionic hand India, myoelectric prosthesis, prosthetic foot, prosthetic knee joint, prosthetic hip joint, orthotics clinic India, pediatric orthotics, AFO brace, SMO orthosis, CROW walker, diabetic foot care, silicone prosthesis India, cosmetic prosthetic cover, rehabilitation center India, mobility aids India, wheelchair supplier India, CP chair, rollator walker, smart blind stick, hearing aid India, upper limb prosthesis, lower limb prosthesis, sports prosthetics, running blade India, artificial hand India, advanced prosthetics worldwide, limb replacement surgery support, prosthetic socket design, prosthetic suspension system, orthotic supports, calipers India, best artificial limb clinic Cuttack, prosthetic clinic Odisha, limbcare Cuttack, international prosthetic solutions, affordable prosthetics India">

    <meta name="author" content="Limbcare Clinic">
    <meta name="robots" content="index, follow">
    <meta name="language" content="English">
    <meta name="revisit-after" content="7 days">
    <meta name="rating" content="General">

    <!-- Open Graph for social sharing -->
    <meta property="og:title" content="Limbcare Clinic | Advanced Prosthetic & Orthotic Solutions in India">
    <meta property="og:description" content="Get advanced artificial limbs, bionic hands, prosthetic legs, orthotics, pediatric braces, silicone prosthesis, and mobility aids at Limbcare Clinic, Cuttack, India. Trusted prosthetic and rehabilitation center delivering global standard care.">
    <meta property="og:type" content="website">
    <meta property="og:locale" content="en_IN">
    <meta property="og:image" content="../assets/images/logos.png">

    <!-- Twitter Card -->
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="Limbcare Clinic | Best Artificial Limb & Orthotic Center in India">
    <meta name="twitter:description" content="Advanced prosthetic legs, bionic hands, orthotic braces, pediatric orthotics, silicone prosthesis and mobility solutions in India. Visit Limbcare Clinic, Cuttack.">
    <meta name="twitter:image" content="../assets/images/logos.png">

    <!-- Clinic Address -->
    <meta name="geo.region" content="IN-OD">
    <meta name="geo.placename" content="Cuttack, Odisha, India">
    <meta name="geo.position" content="20.4625;85.8830">
    <meta name="ICBM" content="20.4625, 85.8830">

    <!-- Favicon -->
    <link rel="icon" type="image/png" sizes="32x32" href="../assets/images/logos.png">
    <link rel="icon" type="image/png" sizes="16x16" href="../assets/images/logos.png">
    <link rel="apple-touch-icon" href="../assets/images/logos.png">

    <meta name="theme-color" content="#0e7aa7">


    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Berkshire+Swash&family=Carter+One&family=Concert+One&family=Laila:wght@300;400;500;600;700&family=Lobster&family=Permanent+Marker&family=Rowdies:wght@300;400;700&family=Rubik+Wet+Paint&family=Satisfy&display=swap');
    </style>
    <style>
        /* Reset and base styles */
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: "Laila", serif;
        }

        /* Main container */
        .spac-container {
            display: flex;
            flex-direction: column;
        }

        /* Header styles */
        .spac-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            font-family: "Laila", serif;
            margin: 0;
            padding: 0;
            background-image: url('../assets/images/footer-bg.png');
            background-position: center;
            background-repeat: no-repeat;
            background-size: cover;
            padding: 0 20px;
            height: 70px;
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            z-index: 1000;
            border-bottom: 1px solid brown;
        }

        .spac-logo {
            display: flex;
            align-items: center;
        }

        .spac-logo img {
            height: 60px;
            margin-right: 10px;
        }

        .spac-logo-text {
            font-size: 1.5rem;
            font-weight: bold;
        }

        .spac-header-right {
            display: flex;
            align-items: center;
        }

        .spac-settings-btn {
            background: none;
            border: none;
            color: brown;
            font-size: 1.5rem;
            cursor: pointer;
            padding: 5px;
            border-radius: 50%;
            transition: background-color 0.3s;
        }

        .spac-settings-btn:hover {
            background-color: rgba(255, 255, 255, 0.1);
        }

        .spac-dropdown {
            position: relative;
        }

        .spac-dropdown-content {
            display: none;
            position: absolute;
            right: 0;
            background-color: white;
            min-width: 160px;
            box-shadow: 0px 8px 16px 0px rgba(0, 0, 0, 0.2);
            z-index: 1;
            border-radius: 5px;
            overflow: hidden;
        }

        .spac-dropdown-content a {
            color: #0a2c5a;
            padding: 12px 16px;
            text-decoration: none;
            display: block;
            transition: background-color 0.3s;
        }

        .spac-dropdown-content a:hover {
            background-color: #f1f1f1;
        }

        .spac-hamburger {
            display: none;
            background: none;
            border: none;
            color: brown;
            font-size: 1.5rem;
            cursor: pointer;
        }

        /* Main content area */
        .spac-main-content {
            display: flex;
            margin-top: 70px;
            flex: 1;
        }

        /* Sidebar styles */
        .spac-sidebar {
            width: 250px;
            font-family: "Laila", serif;
            margin: 0;
            padding: 0;
            background-image: url('../assets/images/footer-bg.png');
            background-position: center;
            background-repeat: no-repeat;
            background-size: cover;
            height: calc(100vh - 140px);
            overflow-y: auto;
            transition: transform 0.3s ease;
            position: fixed;
            left: 0;
            top: 70px;
            bottom: 70px;
            border-right: 1.5px solid brown;
        }

        .spac-sidebar-links {
            padding: 0px 0;
        }

        .spac-sidebar-link {
            display: flex;
            align-items: center;
            padding: 10px 20px;
            color: brown;
            text-decoration: none;
            transition: background-color 0.3s;
            font-family: "Laila", serif;
            font-weight: 500;
        }

        .spac-sidebar-link:hover {
            background-color: rgba(255, 255, 255, 0.1);
        }

        .spac-sidebar-link i {
            margin-right: 10px;
            width: 20px;
            text-align: center;
        }

        .spac-sidebar-link.active {
            background-color: rgba(255, 255, 255, 0.2);
            border-left: 4px solid #ffffff;
        }

        /* Content area */
        .spac-content {
            flex: 1;
            margin-left: 250px;
            padding: 20px;
            background-color: #f5f5f5;
            min-height: calc(100vh - 140px);
        }

        /* Footer styles */
        .spac-footer {
            font-family: "Laila", serif;
            margin: 0;
            padding: 0;
            background-image: url('../assets/images/footer-bg.png');
            background-position: center;
            background-repeat: no-repeat;
            background-size: cover;
            height: 70px;
            display: flex;
            justify-content: center;
            align-items: center;
            position: fixed;
            bottom: 0;
            left: 0;
            right: 0;
            z-index: 1000;
            border-top: 1px solid brown;
        }

        .spac-footer-content {
            display: flex;
            justify-content: space-between;
            width: 100%;
            max-width: 1200px;
            padding: 0 20px;
        }

        .spac-footer-links {
            display: flex;
            gap: 20px;
        }

        .spac-footer-link {
            color: brown;
            text-decoration: none;
            transition: color 0.3s;
            font-weight: 500;
        }

        .spac-footer-link:hover {
            color: #a0c8ff;
        }

        /* Mobile responsive styles */
        @media (max-width: 768px) {
            .spac-hamburger {
                display: block;
            }

            .spac-sidebar {
                transform: translateX(-100%);
                z-index: 999;
            }

            .spac-sidebar.active {
                transform: translateX(0);
            }

            .spac-content {
                margin-left: 0;
            }

            .spac-footer-content {
                flex-direction: column;
                text-align: center;
                gap: 10px;
            }

            .spac-footer,
            .spac-dropdown {
                display: none;
            }
        }
    </style>
</head>

<body>
    <div class="spac-container">
        <!-- Header -->
        <header class="spac-header">
            <div class="spac-logo">
                <a href="./dashboard.php"><img src="../assets/images/logo.png" alt="SDMASAURHI PRIVATE LIMITED Logo" style="border-radius: 10px;"></a>
            </div>
            <div class="spac-header-right">
                <button class="spac-hamburger" id="spac-hamburger">
                    <i class="fas fa-bars"></i>
                </button>
                <div class="spac-dropdown">
                    <button class="spac-settings-btn" id="spac-settings-btn">
                        <i class="fas fa-cog"></i>
                    </button>
                    <div class="spac-dropdown-content" id="spac-dropdown">
                        <a href="logout.php">Logout</a>
                    </div>
                </div>
            </div>
        </header>

        <!-- Main Content -->
        <div class="spac-main-content">
            <!-- Sidebar -->
            <aside class="spac-sidebar" id="spac-sidebar">
                <div class="spac-sidebar-links">

                    <a href="./dashboard.php" class="spac-sidebar-link active">
                        <i class="fas fa-gauge-high"></i>
                        <span>Dashboard</span>
                    </a>

                    <a href="./manage_gallery.php" class="spac-sidebar-link">
                        <i class="fas fa-right-from-bracket"></i>
                        <span>Image Gallery</span>
                    </a>

                    <a href="./manage_blogs.php" class="spac-sidebar-link">
                        <i class="fas fa-right-from-bracket"></i>
                        <span>Manage Blogs</span>
                    </a>

                    <a href="./manage_careers.php" class="spac-sidebar-link">
                        <i class="fas fa-right-from-bracket"></i>
                        <span>Manage Vacancy</span>
                    </a>

                    <a href="./manage_applications.php" class="spac-sidebar-link">
                        <i class="fas fa-right-from-bracket"></i>
                        <span>Career Applications</span>
                    </a>

                    <a href="./manage_product_categories.php" class="spac-sidebar-link">
                        <i class="fas fa-right-from-bracket"></i>
                        <span>Products Category</span>
                    </a>

                    <a href="manage_products.php" class="spac-sidebar-link">
                        <i class="fas fa-right-from-bracket"></i>
                        <span>Manage Products</span>
                    </a>

                    <a href="./manage_contact.php" class="spac-sidebar-link">
                        <i class="fas fa-right-from-bracket"></i>
                        <span>Contact Enquiries</span>
                    </a>

                    <a href="./manage_admin.php" class="spac-sidebar-link">
                        <i class="fas fa-right-from-bracket"></i>
                        <span>Manage admin</span>
                    </a>

                    <a href="./logout.php" class="spac-sidebar-link">
                        <i class="fas fa-right-from-bracket"></i>
                        <span>Logout</span>
                    </a>

                </div>
            </aside>
        </div>



        <!-- Footer -->
        <footer class="spac-footer">
            <div class="spac-footer-content">
                <div class="spac-footer-copyright" style="color:brown; font-weight: 500;">
                    &copy; 2026 Limbcare Clinic. All rights reserved.
                </div>
                <div class="spac-footer-links">
                    <a href="https://erainfotech.in" target="_blank" class="spac-footer-link">Design & Developed By Erainfotech</a>
                </div>
            </div>
        </footer>
    </div>

    <script>
        // Toggle dropdown menu
        document.getElementById('spac-settings-btn').addEventListener('click', function() {
            document.getElementById('spac-dropdown').style.display =
                document.getElementById('spac-dropdown').style.display === 'block' ? 'none' : 'block';
        });

        // Close dropdown when clicking outside
        window.addEventListener('click', function(event) {
            if (!event.target.matches('.spac-settings-btn') && !event.target.matches('.fa-cog')) {
                document.getElementById('spac-dropdown').style.display = 'none';
            }
        });

        // Toggle sidebar on mobile
        document.getElementById('spac-hamburger').addEventListener('click', function() {
            document.getElementById('spac-sidebar').classList.toggle('active');
        });

        // Close sidebar when clicking a link on mobile
        document.querySelectorAll('.spac-sidebar-link').forEach(link => {
            link.addEventListener('click', function() {
                if (window.innerWidth <= 768) {
                    document.getElementById('spac-sidebar').classList.remove('active');
                }
            });
        });

        // Set active link
        document.querySelectorAll('.spac-sidebar-link').forEach(link => {
            link.addEventListener('click', function() {
                document.querySelectorAll('.spac-sidebar-link').forEach(l => {
                    l.classList.remove('active');
                });
                this.classList.add('active');
            });
        });
    </script>
</body>

</html>