<?php
ob_start();
session_start();
include 'includes.php';
include 'connection.php';
// Check if admin is logged in
if (!isset($_SESSION['admin'])) {
    header('Location: index.php');
    exit;
}


// Get counts for each section
$galleryCount = $conn->query("SELECT COUNT(*) as cnt FROM gallery")->fetch_assoc()['cnt'];
$enquiriesCount = $conn->query("SELECT COUNT(*) as cnt FROM 	contact_enquiries	")->fetch_assoc()['cnt'];
$design_pages = $conn->query("SELECT COUNT(*) as cnt FROM careers")->fetch_assoc()['cnt'];
$material = $conn->query("SELECT COUNT(*) as cnt FROM products")->fetch_assoc()['cnt'];
$admins = $conn->query("SELECT COUNT(*) as cnt FROM admin")->fetch_assoc()['cnt'];
$notifications = $conn->query("SELECT COUNT(*) as cnt FROM blogs")->fetch_assoc()['cnt'];
$career = $conn->query("SELECT COUNT(*) as cnt FROM reviews")->fetch_assoc()['cnt'];
?>
<div class="spac-content">
    <div class="spac-dashboard-container">
        <!-- Dashboard Heading -->
        <div class="spac-dashboard-heading">
            <h2>Welcome To Limbcare Clinic Admin Dashboard</h2>
        </div>

        <!-- Dashboard Cards -->
        <div class="spac-cards-container">

            <div class="spac-card project-card">
                <div class="spac-card-icon">
                    <i class="fas fa-gauge-high"></i>
                </div>
                <div class="spac-card-content">
                    <a href="dashboard.php">
                        <h3 class="spac-card-title">Dashboard</h3>
                    </a>
                    <div class="spac-card-count">9</div>
                </div>
            </div>

            <div class="spac-card gallery-card">
                <div class="spac-card-icon">
                    <i class="fas fa-image"></i>
                </div>
                <div class="spac-card-content">
                    <a href="./manage_gallery.php">
                        <h3 class="spac-card-title">Gallery</h3>
                    </a>
                    <div class="spac-card-count"><?= $galleryCount ?></div>
                </div>
            </div>

            <div class="spac-card career-card">
                <div class="spac-card-icon">
                    <i class="fas fa-book"></i>
                </div>
                <div class="spac-card-content">
                    <a href="./manage_careers.php">
                        <h3 class="spac-card-title">Manage Vacancy</h3>
                    </a>
                    <div class="spac-card-count"><?= $design_pages ?></div>
                </div>
            </div>

            <div class="spac-card career-card">
                <div class="spac-card-icon">
                    <i class="fas fa-users"></i>
                </div>
                <div class="spac-card-content">
                    <a href="manage_reviews.php">
                        <h3 class="spac-card-title">Manage Reviews</h3>
                    </a>
                    <div class="spac-card-count"><?= $career ?></div>
                </div>
            </div>

            <div class="spac-card applications-card">
                <div class="spac-card-icon">
                    <i class="fas fa-wheelchair"></i>
                </div>
                <div class="spac-card-content">
                    <a href="manage_products.php">
                        <h3 class="spac-card-title">Manage Products</h3>
                    </a>
                    <div class="spac-card-count"><?= $material ?></div>
                </div>
            </div>

            <div class="spac-card applications-card">
                <div class="spac-card-icon">
                    <i class="fas fa-blog"></i>
                </div>
                <div class="spac-card-content">
                    <a href="manage_blogs.php">
                        <h3 class="spac-card-title">Manage Blogs</h3>
                    </a>
                    <div class="spac-card-count"><?= $notifications ?></div>
                </div>
            </div>

            <div class="spac-card enquiry-card">
                <div class="spac-card-icon">
                    <i class="fas fa-envelope"></i>
                </div>
                <div class="spac-card-content">
                    <a href="./manage_contact.php">
                        <h3 class="spac-card-title">Contact Enquiries</h3>
                    </a>
                    <div class="spac-card-count"><?= $enquiriesCount ?></div>
                </div>
            </div>

            <div class="spac-card visitors-card">
                <div class="spac-card-icon">
                    <i class="fas fa-user-shield"></i>
                </div>
                <div class="spac-card-content">
                    <a href="./manage_admin.php">
                        <h3 class="spac-card-title">Manage Admin</h3>
                    </a>
                    <div class="spac-card-count"><?= $admins ?></div>
                </div>
            </div>

            <div class="spac-card visitors-card">
                <div class="spac-card-icon">
                    <i class="fas fa-right-from-bracket"></i>
                </div>
                <div class="spac-card-content">
                    <a href="./logout.php">
                        <h3 class="spac-card-title">Logout</h3>
                    </a>
                    <div class="spac-card-count">1</div>
                </div>
            </div>

        </div>
    </div>
</div><br>
<style>
    @import url('https://fonts.googleapis.com/css2?family=Berkshire+Swash&family=Carter+One&family=Concert+One&family=Laila:wght@300;400;500;600;700&family=Lobster&family=Permanent+Marker&family=Rowdies:wght@300;400;700&family=Rubik+Wet+Paint&family=Satisfy&display=swap');
</style>
<style>
    a {
        text-decoration: none;
    }

    .spac-content {

        font-family: "Laila", serif;
        background-image: url('../assets/images/footer-bg.png');
        background-position: center;
        background-repeat: no-repeat;
        background-size: cover;
    }

    .spac-dashboard-container {
        padding: 10px 5px;
        /* Reduced padding */
        max-width: 1400px;
        margin: 0 auto;
        overflow-x: auto;
        /* Enables horizontal scrolling for the container */
    }

    /* Dashboard Heading */
    .spac-dashboard-heading {
        text-align: center;
        margin-bottom: 20px;
        font-family: "Laila", serif;
    }

    .spac-dashboard-heading h2 {
        color: brown;
        font-size: 1.7rem;
        font-weight: 700;
        text-shadow: 0 2px 4px rgba(0, 0, 0, 0.3);
        margin: 20px 0;
    }

    /* Dashboard Cards */
    .spac-cards-container {
        display: flex;
        flex-wrap: wrap;
        /* Changed from nowrap to wrap to allow cards to wrap to next line */
        gap: 10px;
        /* Reduced gap between cards */
        margin-bottom: 30px;
        justify-content: left;
        /* Changed to center to align cards in the middle */
        padding-bottom: 5px;
    }

    .spac-card {
        flex: 0 0 calc(30.666% + 20px);
        /* Changed to show exactly 6 cards per line (100% / 6) minus gap */
        font-family: "Laila", serif;
        margin: 0;
        padding: 0;
        background-image: url('../assets/images/footer-bg.png');
        background-position: center;
        background-repeat: no-repeat;
        background-size: cover;
        border-radius: 10px;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.12);
        overflow: hidden;
        transition: all 0.3s ease;
        position: relative;
        min-height: 100px;
        /* Fixed small height */
        display: flex;
        flex-direction: column;
        align-items: center;
        justify-content: center;
        text-align: center;
    }

    /* Colored top border for each card type */
    .spac-card::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        height: 3px;
        /* Thinner border */
    }

    .gallery-card::before {
        background: brown;
    }

    .enquiry-card::before {
        background: brown;
    }

    .career-card::before {
        background: brown;
    }

    .applications-card::before {
        background: brown;
    }

    .project-card::before {
        background: brown;
    }

    .visitors-card::before {
        background: brown;
    }

    .spac-card:hover {
        transform: translateY(-3px);
        box-shadow: 0 4px 12px rgba(0, 0, 0, 0.18);
    }

    .spac-card-icon {
        font-size: 1.4rem;
        /* Smaller icon */
        margin-bottom: 5px;
    }

    .gallery-card .spac-card-icon {
        color: brown;
    }

    .enquiry-card .spac-card-icon {
        color: brown;
    }

    .career-card .spac-card-icon {
        color: brown;
    }

    .applications-card .spac-card-icon {
        color: brown;
    }

    .project-card .spac-card-icon {
        color: brown;
    }

    .visitors-card .spac-card-icon {
        color: brown;
    }

    .spac-card-content {
        padding: 5px 10px;
        /* Minimal padding */
    }

    .spac-card-title {
        font-size: 1rem;
        /* Smaller title font */
        color: brown;
        margin: 0 0 4px;
        font-weight: 600;
        line-height: 1.1;
    }

    .spac-card-count {
        font-size: 1.5rem;
        /* Smaller count font */
        font-weight: 700;
        color: brown;
        margin: 0;
    }

    /* Responsive adjustments for smaller screens */
    @media (max-width: 1200px) {
        .spac-card {
            flex: 0 0 calc(16.666% - 10px);
            /* Keep 6 cards per line */
        }

        .spac-dashboard-heading h2 {
            font-size: 1.8rem;
        }
    }

    @media (max-width: 992px) {
        .spac-card {
            flex: 0 0 calc(25% - 10px);
            /* 4 cards per line on medium screens */
        }
    }

    @media (max-width: 768px) {
        .spac-card {
            flex: 0 0 calc(33.333% - 10px);
            /* 3 cards per line on tablets */
        }

        .spac-card-title {
            font-size: 0.7rem;
        }

        .spac-card-count {
            font-size: 1.4rem;
        }

        .spac-dashboard-heading h2 {
            font-size: 1.6rem;
        }
    }

    @media (max-width: 480px) {
        .spac-card {
            flex: 0 0 calc(50% - 5px);
            /* 2 cards per line on mobile */
        }

        .spac-cards-container {
            gap: 8px;
        }

        .spac-dashboard-heading h2 {
            font-size: 1.4rem;
        }
    }

    /* Recent Activity - Unchanged Styles */
    .spac-recent-container {
        display: flex;
        gap: 20px;
        flex-wrap: wrap;
    }

    .spac-recent-box {
        flex: 1;
        min-width: 250px;
        background: brown;
        border-radius: 10px;
        box-shadow: 0 4px 12px rgba(0, 0, 0, 0.08);
        padding: 20px;
    }

    .spac-recent-title {
        font-size: 1.1rem;
        color: #0a2c5a;
        margin-top: 0;
        margin-bottom: 15px;
        padding-bottom: 10px;
        border-bottom: 1px solid #eee;
    }

    .spac-recent-list {
        list-style: none;
        padding: 0;
        margin: 0;
    }

    .spac-recent-list li {
        display: flex;
        justify-content: space-between;
        padding: 10px 0;
        border-bottom: 1px solid #f5f5f5;
    }

    .spac-recent-list li:last-child {
        border-bottom: none;
    }

    .spac-recent-name {
        font-weight: 500;
        color: #333;
    }

    .spac-recent-date {
        color: #777;
        font-size: 0.85rem;
    }

    .spac-no-data {
        color: #999;
        font-style: italic;
        text-align: center;
        padding: 15px 0;
    }
</style>