<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <title>Limbcare Clinic | Best Prosthetic & Orthotic Center in India | Artificial Limbs & Bionic Solutions</title>

    <meta name="description" content="Limbcare Clinic is a leading Prosthetic and Orthotic Center in India providing advanced artificial limbs, bionic hands, prosthetic legs, orthotics, pediatric orthotics, silicone prosthesis, mobility aids, wheelchairs, and rehabilitation solutions. Located at Beside Brahmkumari Ashram, Anantpur, Phulnakhara, Cuttack Near East College. We deliver customized, high-quality prosthetic and orthotic care with global standards.">

    <meta name="keywords" content="Limbcare Clinic, best prosthetic clinic in India, prosthetic leg India, artificial limb center, bionic hand India, myoelectric prosthesis, prosthetic foot, prosthetic knee joint, prosthetic hip joint, orthotics clinic India, pediatric orthotics, AFO brace, SMO orthosis, CROW walker, diabetic foot care, silicone prosthesis India, cosmetic prosthetic cover, rehabilitation center India, mobility aids India, wheelchair supplier India, CP chair, rollator walker, smart blind stick, hearing aid India, upper limb prosthesis, lower limb prosthesis, sports prosthetics, running blade India, artificial hand India, advanced prosthetics worldwide, limb replacement surgery support, prosthetic socket design, prosthetic suspension system, orthotic supports, calipers India, best artificial limb clinic Cuttack, prosthetic clinic Odisha, limbcare Cuttack, international prosthetic solutions, affordable prosthetics India">

    <meta name="author" content="Limbcare Clinic">
    <meta name="robots" content="index, follow">
    <meta name="language" content="English">
    <meta name="revisit-after" content="7 days">
    <meta name="rating" content="General">

    <!-- Open Graph for social sharing -->
    <meta property="og:title" content="Limbcare Clinic | Advanced Prosthetic & Orthotic Solutions in India">
    <meta property="og:description" content="Get advanced artificial limbs, bionic hands, prosthetic legs, orthotics, pediatric braces, silicone prosthesis, and mobility aids at Limbcare Clinic, Cuttack, India. Trusted prosthetic and rehabilitation center delivering global standard care.">
    <meta property="og:type" content="website">
    <meta property="og:locale" content="en_IN">
    <meta property="og:image" content="assets/images/logos.png">

    <!-- Twitter Card -->
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="Limbcare Clinic | Best Artificial Limb & Orthotic Center in India">
    <meta name="twitter:description" content="Advanced prosthetic legs, bionic hands, orthotic braces, pediatric orthotics, silicone prosthesis and mobility solutions in India. Visit Limbcare Clinic, Cuttack.">
    <meta name="twitter:image" content="assets/images/logos.png">

    <!-- Clinic Address -->
    <meta name="geo.region" content="IN-OD">
    <meta name="geo.placename" content="Cuttack, Odisha, India">
    <meta name="geo.position" content="20.4625;85.8830">
    <meta name="ICBM" content="20.4625, 85.8830">

    <!-- Favicon -->
    <link rel="icon" type="image/png" sizes="32x32" href="./assets/images/logos.png">
    <link rel="icon" type="image/png" sizes="16x16" href="./assets/images/logos.png">
    <link rel="apple-touch-icon" href="./assets/images/logos.png">

    <meta name="theme-color" content="#0e7aa7">
    <link rel="stylesheet" href="./css/style.css">
    <style>
        /* ================= PAGE BANNER ================= */

        .ias-page-banner {
            width: 100%;
            height: 220px;
            background: url("./assets/images/bns.jpg") center center / cover no-repeat;
            position: relative;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .ias-banner-overlay {
            width: 100%;
            height: 100%;
            background: rgba(14, 122, 167, 0.85);
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .ias-banner-overlay h1 {
            color: #fff;
            font-size: 40px;
            font-weight: 600;
            letter-spacing: 1px;
        }

        /* ================= BREADCRUMB ================= */

        .ias-breadcrumb-wrapper {
            background: #f2f2f2;
            padding: 12px 40px;
        }

        .ias-breadcrumb {
            font-size: 14px;
        }

        .ias-breadcrumb a {
            color: #0e7aa7;
            text-decoration: none;
        }

        .ias-breadcrumb span {
            color: #333;
        }

        /* ================= RESPONSIVE ================= */

        @media (max-width: 768px) {

            .ias-page-banner {
                height: 170px;
            }

            .ias-banner-overlay h1 {
                font-size: 28px;
            }

            .ias-breadcrumb-wrapper {
                padding: 10px 20px;
            }

        }
    </style>
</head>

<body>
    <?php include 'header.php' ?>
    <section class="ias-page-banner">

        <div class="ias-banner-overlay">
            <h1>About Us</h1>
        </div>

    </section>

    <div class="ias-breadcrumb-wrapper">
        <div class="ias-breadcrumb">
            <a href="index.php">Home</a> / <span>Who We Are</span>
        </div>
    </div>

    <!-- ================= ABOUT SECTION ================= -->

    <section class="ias-about-section">

        <div class="ias-about-container">

            <div class="ias-about-row">

                <!-- LEFT CONTENT -->
                <div class="ias-about-content">

                    <h2 class="ias-about-title">
                        About <span class="span">Limbcare Clinic</span>
                    </h2>

                    <p class="ias-about-text">
                        Limbcare Clinic is a trusted prosthetic and orthotic center in India. It helps people who have lost a limb or have physical difficulties to move better and feel confident again. The clinic provides artificial body parts that are comfortable, strong, and made with proper care. Their main aim is to help patients live an independent and happy life.
                    </p>

                    <p class="ias-about-text">
                        The clinic offers prosthetic limbs, orthotic supports, and silicone solutions for both support and natural appearance. They use modern technology and good quality materials to make lightweight and durable products. Each device is made after proper checking and measurement. The team also ensures correct fitting and gives full guidance for better recovery.
                    </p>

                    <p class="ias-about-text">
                        Limbcare Clinic has experienced prosthetists and rehabilitation experts who care for every patient. From first consultation to after-service support, complete assistance is provided. The clinic follows high-quality standards in all treatments. With dedication and care, Limbcare Clinic continues to improve the lives of many people across India.
                    </p>

                </div>

                <!-- RIGHT IMAGE -->
                <div class="ias-about-image">
                    <img src="./assets/images/about.jpg" alt="About Image">
                </div>

            </div>

        </div>

    </section>

    <!-- ================= MISSION VISION VALUES SECTION ================= -->

    <section class="ias-mvv-section">

        <div class="ias-mvv-container">

            <!-- Tab Buttons -->
            <div class="ias-mvv-tabs">

                <button class="ias-mvv-tab-btn active" data-tab="mission">
                    Mission
                </button>

                <button class="ias-mvv-tab-btn" data-tab="vision">
                    Vision
                </button>

                <button class="ias-mvv-tab-btn" data-tab="values">
                    Core Values
                </button>

            </div>

            <!-- Tab Content -->
            <div class="ias-mvv-content-wrapper">

                <!-- Mission -->
                <div class="ias-mvv-content active" id="mission">
                    <h3>Our <span class="span">Mission</span></h3>
                    <p>
                        Our mission is to provide high-quality prosthetic, orthotic, and silicone solutions that restore mobility, comfort, and confidence. We are dedicated to offering personalized care using modern technology and advanced techniques. Our focus is to support every patient with proper guidance, rehabilitation, and long-term care so they can lead an independent and active life.
                    </p>
                </div>

                <!-- Vision -->
                <div class="ias-mvv-content" id="vision">
                    <h3>Our <span class="span">Vision</span></h3>
                    <p>
                        Our vision is to become one of the most trusted and leading prosthetic and orthotic clinics in India. We aim to be recognized for innovation, quality service, and compassionate patient care. We strive to continuously improve our services and adopt the latest advancements to transform lives and set new standards in rehabilitation.
                    </p>
                </div>

                <!-- Core Values -->
                <div class="ias-mvv-content" id="values">
                    <h3>Our <span class="span">Core Values</span></h3>
                    <p>
                        We believe in compassion, respect, and integrity in every interaction. Patient-centered care, quality workmanship, and ethical practices are at the heart of everything we do. We value innovation, teamwork, and continuous learning to ensure the best possible outcomes for every individual we serve.
                    </p>
                </div>

            </div>

        </div>

    </section>
    <?php include 'footer.php' ?>

    <script>
        const iasTabs = document.querySelectorAll(".ias-mvv-tab-btn");
        const iasContents = document.querySelectorAll(".ias-mvv-content");

        iasTabs.forEach(tab => {

            tab.addEventListener("click", function() {

                const target = this.getAttribute("data-tab");

                iasTabs.forEach(btn => btn.classList.remove("active"));
                iasContents.forEach(content => content.classList.remove("active"));

                this.classList.add("active");
                document.getElementById(target).classList.add("active");

            });

        });
    </script>
</body>

</html>